/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.microblog;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.microblog.MicroblogProfile;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="microblog-configuration")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="microblog-configuration.xsd")
public class MicroblogConfiguration
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlAttribute(name="default-microblog-profile-name", required=true)
    private String m_defaultMicroblogProfileName;
    @XmlElement(name="microblog-profile", required=true)
    private List<MicroblogProfile> m_profiles = new ArrayList<MicroblogProfile>();

    public String getDefaultMicroblogProfileName() {
        return this.m_defaultMicroblogProfileName;
    }

    public void setDefaultMicroblogProfileName(String name) {
        this.m_defaultMicroblogProfileName = ConfigUtils.assertNotEmpty(name, "default-microblog-profile-name");
    }

    public List<MicroblogProfile> getMicroblogProfiles() {
        return this.m_profiles;
    }

    public void setMicroblogProfiles(List<MicroblogProfile> profiles) {
        if (profiles == this.m_profiles) {
            return;
        }
        this.m_profiles.clear();
        if (profiles != null) {
            this.m_profiles.addAll(profiles);
        }
    }

    public void addMicroblogProfile(MicroblogProfile profile) {
        this.m_profiles.add(profile);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MicroblogConfiguration) {
            MicroblogConfiguration that = (MicroblogConfiguration)obj;
            return Objects.equals(this.m_defaultMicroblogProfileName, that.m_defaultMicroblogProfileName) && Objects.equals(this.m_profiles, that.m_profiles);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.m_defaultMicroblogProfileName, this.m_profiles);
    }
}

