/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.rancid.adapter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.rancid.adapter.Mapping;
import org.opennms.netmgt.config.rancid.adapter.Policies;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="rancid-configuration")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="rancid-adapter-configuration.xsd")
public class RancidConfiguration
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final String DEFAULT_DEFAULT_TYPE = "cisco";
    @XmlAttribute(name="delay", required=true)
    private Long m_delay;
    @XmlAttribute(name="retries", required=true)
    private Integer m_retries;
    @XmlAttribute(name="useCategories")
    private Boolean m_useCategories;
    @XmlAttribute(name="default-type")
    private String m_defaultType;
    @XmlElement(name="policies")
    private Policies m_policies;
    @XmlElement(name="mapping")
    private List<Mapping> m_mappings = new ArrayList<Mapping>();

    public Long getDelay() {
        return this.m_delay;
    }

    public void setDelay(Long delay) {
        this.m_delay = ConfigUtils.assertNotNull(delay, "delay");
    }

    public Integer getRetries() {
        return this.m_retries;
    }

    public void setRetries(Integer retries) {
        this.m_retries = ConfigUtils.assertNotNull(retries, "retries");
    }

    public Boolean getUseCategories() {
        return this.m_useCategories != null ? this.m_useCategories : Boolean.FALSE;
    }

    public void setUseCategories(Boolean useCategories) {
        this.m_useCategories = useCategories;
    }

    public String getDefaultType() {
        return this.m_defaultType != null ? this.m_defaultType : DEFAULT_DEFAULT_TYPE;
    }

    public void setDefaultType(String defaultType) {
        this.m_defaultType = ConfigUtils.normalizeString(defaultType);
    }

    public Optional<Policies> getPolicies() {
        return Optional.ofNullable(this.m_policies);
    }

    public void setPolicies(Policies policies) {
        this.m_policies = policies;
    }

    public List<Mapping> getMappings() {
        return this.m_mappings;
    }

    public void setMappings(List<Mapping> mappings) {
        if (mappings == this.m_mappings) {
            return;
        }
        this.m_mappings.clear();
        if (mappings != null) {
            this.m_mappings.addAll(mappings);
        }
    }

    public void addMapping(Mapping mapping) {
        this.m_mappings.add(mapping);
    }

    public boolean removeMapping(Mapping mapping) {
        return this.m_mappings.remove(mapping);
    }

    public int hashCode() {
        return Objects.hash(this.m_delay, this.m_retries, this.m_useCategories, this.m_defaultType, this.m_policies, this.m_mappings);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RancidConfiguration) {
            RancidConfiguration that = (RancidConfiguration)obj;
            return Objects.equals(this.m_delay, that.m_delay) && Objects.equals(this.m_retries, that.m_retries) && Objects.equals(this.m_useCategories, that.m_useCategories) && Objects.equals(this.m_defaultType, that.m_defaultType) && Objects.equals(this.m_policies, that.m_policies) && Objects.equals(this.m_mappings, that.m_mappings);
        }
        return false;
    }
}

