/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.statsd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.statsd.Package;
import org.opennms.netmgt.config.statsd.Report;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="statistics-daemon-configuration")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="statistics-daemon-configuration.xsd")
public class StatisticsDaemonConfiguration
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlElement(name="package", required=true)
    private List<Package> m_packages = new ArrayList<Package>();
    @XmlElement(name="report", required=true)
    private List<Report> m_reports = new ArrayList<Report>();

    public List<Package> getPackages() {
        return this.m_packages;
    }

    public void setPackages(List<Package> packages) {
        ConfigUtils.assertMinimumSize(packages, 1L, "package");
        if (packages == this.m_packages) {
            return;
        }
        this.m_packages.clear();
        if (packages != null) {
            this.m_packages.addAll(packages);
        }
    }

    public void addPackage(Package p) {
        this.m_packages.add(p);
    }

    public boolean removePackage(Package p) {
        return this.m_packages.remove(p);
    }

    public List<Report> getReports() {
        return this.m_reports;
    }

    public void setReports(List<Report> reports) {
        ConfigUtils.assertMinimumSize(reports, 1L, "report");
        if (reports == this.m_reports) {
            return;
        }
        this.m_reports.clear();
        if (reports != null) {
            this.m_reports.addAll(reports);
        }
    }

    public void addReport(Report report) {
        this.m_reports.add(report);
    }

    public boolean removeReport(Report report) {
        return this.m_reports.remove(report);
    }

    public int hashCode() {
        return Objects.hash(this.m_packages, this.m_reports);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof StatisticsDaemonConfiguration) {
            StatisticsDaemonConfiguration that = (StatisticsDaemonConfiguration)obj;
            return Objects.equals(this.m_packages, that.m_packages) && Objects.equals(this.m_reports, that.m_reports);
        }
        return false;
    }
}

