/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.statsd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.statsd.Filter;
import org.opennms.netmgt.config.statsd.PackageReport;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="package")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="statistics-daemon-configuration.xsd")
public class Package
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlAttribute(name="name", required=true)
    private String m_name;
    @XmlElement(name="filter")
    private Filter m_filter;
    @XmlElement(name="packageReport")
    private List<PackageReport> m_packageReports = new ArrayList<PackageReport>();

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = ConfigUtils.assertNotEmpty(name, "name");
    }

    public Optional<Filter> getFilter() {
        return Optional.ofNullable(this.m_filter);
    }

    public void setFilter(Filter filter) {
        this.m_filter = filter;
    }

    public List<PackageReport> getPackageReports() {
        return this.m_packageReports;
    }

    public void setPackageReports(List<PackageReport> packageReports) {
        if (packageReports == this.m_packageReports) {
            return;
        }
        this.m_packageReports.clear();
        if (packageReports != null) {
            this.m_packageReports.addAll(packageReports);
        }
    }

    public void addPackageReport(PackageReport packageReport) {
        this.m_packageReports.add(packageReport);
    }

    public boolean removePackageReport(PackageReport packageReport) {
        return this.m_packageReports.remove(packageReport);
    }

    public int hashCode() {
        return Objects.hash(this.m_name, this.m_filter, this.m_packageReports);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Package) {
            Package that = (Package)obj;
            return Objects.equals(this.m_name, that.m_name) && Objects.equals(this.m_filter, that.m_filter) && Objects.equals(this.m_packageReports, that.m_packageReports);
        }
        return false;
    }
}

