/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.server;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.opennms.core.network.InetAddressXmlAdapter;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="local-server")
@ValidateUsing(value="opennms-server.xsd")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class LocalServer
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlAttribute(name="server-name")
    private String m_serverName;
    @XmlAttribute(name="defaultCriticalPathIp")
    @XmlJavaTypeAdapter(value=InetAddressXmlAdapter.class)
    private InetAddress m_defaultCriticalPathIp;
    @XmlAttribute(name="defaultCriticalPathService")
    private String m_defaultCriticalPathService;
    @XmlAttribute(name="defaultCriticalPathTimeout")
    private Integer m_defaultCriticalPathTimeout;
    @XmlAttribute(name="defaultCriticalPathRetries")
    private Integer m_defaultCriticalPathRetries;
    @XmlAttribute(name="verify-server")
    private Boolean m_verifyServer;

    public String getServerName() {
        return this.m_serverName == null ? "localhost" : this.m_serverName;
    }

    public void setServerName(String serverName) {
        this.m_serverName = ConfigUtils.normalizeString(serverName);
    }

    public Optional<InetAddress> getDefaultCriticalPathIp() {
        return Optional.ofNullable(this.m_defaultCriticalPathIp);
    }

    public void setDefaultCriticalPathIp(InetAddress ip) {
        this.m_defaultCriticalPathIp = ip;
    }

    public Optional<String> getDefaultCriticalPathService() {
        return Optional.ofNullable(this.m_defaultCriticalPathService);
    }

    public void setDefaultCriticalPathService(String defaultCriticalPathService) {
        this.m_defaultCriticalPathService = ConfigUtils.normalizeString(defaultCriticalPathService);
    }

    public Integer getDefaultCriticalPathTimeout() {
        return this.m_defaultCriticalPathTimeout == null ? 1500 : this.m_defaultCriticalPathTimeout;
    }

    public void setDefaultCriticalPathTimeout(Integer timeout) {
        this.m_defaultCriticalPathTimeout = timeout;
    }

    public int getDefaultCriticalPathRetries() {
        return this.m_defaultCriticalPathRetries == null ? 0 : this.m_defaultCriticalPathRetries;
    }

    public void setDefaultCriticalPathRetries(Integer retries) {
        this.m_defaultCriticalPathRetries = retries;
    }

    public Boolean getVerifyServer() {
        return this.m_verifyServer == null ? Boolean.FALSE : this.m_verifyServer;
    }

    public void setVerifyServer(Boolean verifyServer) {
        this.m_verifyServer = verifyServer;
    }

    public int hashCode() {
        return Objects.hash(this.m_serverName, this.m_defaultCriticalPathIp, this.m_defaultCriticalPathService, this.m_defaultCriticalPathTimeout, this.m_defaultCriticalPathRetries, this.m_verifyServer);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LocalServer) {
            LocalServer that = (LocalServer)obj;
            return Objects.equals(this.m_serverName, that.m_serverName) && Objects.equals(this.m_defaultCriticalPathIp, that.m_defaultCriticalPathIp) && Objects.equals(this.m_defaultCriticalPathService, that.m_defaultCriticalPathService) && Objects.equals(this.m_defaultCriticalPathTimeout, that.m_defaultCriticalPathTimeout) && Objects.equals(this.m_defaultCriticalPathRetries, that.m_defaultCriticalPathRetries) && Objects.equals(this.m_verifyServer, that.m_verifyServer);
        }
        return false;
    }
}

