/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.notifications;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.core.xml.YesNoAdapter;
import org.opennms.netmgt.config.notifications.Parameter;
import org.opennms.netmgt.config.notifications.Varbind;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="notification")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="notifications.xsd")
public class Notification
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlAttribute(name="name", required=true)
    private String m_name;
    @XmlAttribute(name="status", required=true)
    private String m_status;
    @XmlAttribute(name="writeable")
    @XmlJavaTypeAdapter(value=YesNoAdapter.class)
    private Boolean m_writeable;
    @XmlElement(name="uei", required=true)
    private String m_uei;
    @XmlElement(name="description")
    private String m_description;
    @XmlElement(name="rule", required=true)
    private String m_rule;
    @XmlElement(name="notice-queue")
    private String m_noticeQueue;
    @XmlElement(name="destinationPath", required=true)
    private String m_destinationPath;
    @XmlElement(name="text-message", required=true)
    private String m_textMessage;
    @XmlElement(name="subject")
    private String m_subject;
    @XmlElement(name="numeric-message")
    private String m_numericMessage;
    @XmlElement(name="event-severity")
    private String m_eventSeverity;
    @XmlElement(name="parameter")
    private List<Parameter> m_parameters = new ArrayList<Parameter>();
    @XmlElement(name="varbind")
    private Varbind m_varbind;

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = ConfigUtils.assertNotEmpty(name, "name");
    }

    public String getStatus() {
        return this.m_status;
    }

    public void setStatus(String status) {
        this.m_status = ConfigUtils.assertNotEmpty(status, "status");
    }

    public Boolean getWriteable() {
        return this.m_writeable != null ? this.m_writeable : Boolean.TRUE;
    }

    public void setWriteable(Boolean writeable) {
        this.m_writeable = writeable;
    }

    public String getUei() {
        return this.m_uei;
    }

    public void setUei(String uei) {
        this.m_uei = ConfigUtils.assertNotEmpty(uei, "uei");
    }

    public Optional<String> getDescription() {
        return Optional.ofNullable(this.m_description);
    }

    public void setDescription(String description) {
        this.m_description = ConfigUtils.normalizeString(description);
    }

    public String getRule() {
        return this.m_rule;
    }

    public void setRule(String rule) {
        this.m_rule = ConfigUtils.assertNotEmpty(rule, "rule");
    }

    public Optional<String> getNoticeQueue() {
        return Optional.ofNullable(this.m_noticeQueue);
    }

    public void setNoticeQueue(String noticeQueue) {
        this.m_noticeQueue = ConfigUtils.normalizeString(noticeQueue);
    }

    public String getDestinationPath() {
        return this.m_destinationPath;
    }

    public void setDestinationPath(String destinationPath) {
        this.m_destinationPath = ConfigUtils.assertNotEmpty(destinationPath, "destinationPath");
    }

    public String getTextMessage() {
        return this.m_textMessage;
    }

    public void setTextMessage(String textMessage) {
        this.m_textMessage = ConfigUtils.assertNotEmpty(textMessage, "text-message");
    }

    public Optional<String> getSubject() {
        return Optional.ofNullable(this.m_subject);
    }

    public void setSubject(String subject) {
        this.m_subject = ConfigUtils.normalizeString(subject);
    }

    public Optional<String> getNumericMessage() {
        return Optional.ofNullable(this.m_numericMessage);
    }

    public void setNumericMessage(String numericMessage) {
        this.m_numericMessage = ConfigUtils.normalizeString(numericMessage);
    }

    public Optional<String> getEventSeverity() {
        return Optional.ofNullable(this.m_eventSeverity);
    }

    public void setEventSeverity(String eventSeverity) {
        this.m_eventSeverity = ConfigUtils.normalizeString(eventSeverity);
    }

    public List<Parameter> getParameters() {
        return this.m_parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        if (parameters == this.m_parameters) {
            return;
        }
        this.m_parameters.clear();
        if (parameters != null) {
            this.m_parameters.addAll(parameters);
        }
    }

    public void addParameter(Parameter parameter) {
        this.m_parameters.add(parameter);
    }

    public boolean removeParameter(Parameter parameter) {
        return this.m_parameters.remove(parameter);
    }

    public Varbind getVarbind() {
        return this.m_varbind;
    }

    public void setVarbind(Varbind varbind) {
        this.m_varbind = varbind;
    }

    public int hashCode() {
        return Objects.hash(this.m_name, this.m_status, this.m_writeable, this.m_uei, this.m_description, this.m_rule, this.m_noticeQueue, this.m_destinationPath, this.m_textMessage, this.m_subject, this.m_numericMessage, this.m_eventSeverity, this.m_parameters, this.m_varbind);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Notification) {
            Notification that = (Notification)obj;
            return Objects.equals(this.m_name, that.m_name) && Objects.equals(this.m_status, that.m_status) && Objects.equals(this.m_writeable, that.m_writeable) && Objects.equals(this.m_uei, that.m_uei) && Objects.equals(this.m_description, that.m_description) && Objects.equals(this.m_rule, that.m_rule) && Objects.equals(this.m_noticeQueue, that.m_noticeQueue) && Objects.equals(this.m_destinationPath, that.m_destinationPath) && Objects.equals(this.m_textMessage, that.m_textMessage) && Objects.equals(this.m_subject, that.m_subject) && Objects.equals(this.m_numericMessage, that.m_numericMessage) && Objects.equals(this.m_eventSeverity, that.m_eventSeverity) && Objects.equals(this.m_parameters, that.m_parameters) && Objects.equals(this.m_varbind, that.m_varbind);
        }
        return false;
    }
}

