/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.javamail;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.javamail.JavamailProperty;
import org.opennms.netmgt.config.javamail.SendmailHost;
import org.opennms.netmgt.config.javamail.SendmailMessage;
import org.opennms.netmgt.config.javamail.SendmailProtocol;
import org.opennms.netmgt.config.javamail.UserAuth;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="sendmail-config", namespace="http://xmlns.opennms.org/xsd/config/javamail-configuration")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="javamail-configuration.xsd")
public class SendmailConfig
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlAttribute(name="debug")
    private Boolean m_debug;
    @XmlAttribute(name="use-authentication")
    private Boolean m_useAuthentication;
    @XmlAttribute(name="use-jmta")
    private Boolean m_useJmta;
    @XmlAttribute(name="attempt-interval")
    private Long m_attemptInterval;
    @XmlAttribute(name="name", required=true)
    private String m_name;
    @XmlElement(name="javamail-property")
    private List<JavamailProperty> m_javamailProperties = new ArrayList<JavamailProperty>();
    @XmlElement(name="sendmail-host", required=true)
    private SendmailHost m_sendmailHost;
    @XmlElement(name="sendmail-protocol", required=true)
    private SendmailProtocol m_sendmailProtocol;
    @XmlElement(name="sendmail-message", required=true)
    private SendmailMessage m_sendmailMessage;
    @XmlElement(name="user-auth", required=true)
    private UserAuth m_userAuth;

    public Boolean isDebug() {
        return this.m_debug == null ? Boolean.TRUE : this.m_debug;
    }

    public void setDebug(Boolean debug) {
        this.m_debug = debug;
    }

    public Boolean isUseAuthentication() {
        return this.m_useAuthentication == null ? Boolean.FALSE : this.m_useAuthentication;
    }

    public void setUseAuthentication(Boolean useAuthentication) {
        this.m_useAuthentication = useAuthentication;
    }

    public Boolean isUseJmta() {
        return this.m_useJmta == null ? Boolean.TRUE : this.m_useJmta;
    }

    public void setUseJmta(Boolean useJmta) {
        this.m_useJmta = useJmta;
    }

    public Long getAttemptInterval() {
        return this.m_attemptInterval == null ? 3000L : this.m_attemptInterval;
    }

    public void setAttemptInterval(Long attemptInterval) {
        this.m_attemptInterval = attemptInterval;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = ConfigUtils.assertNotEmpty(name, "name");
    }

    public List<JavamailProperty> getJavamailProperties() {
        return this.m_javamailProperties;
    }

    public void setJavamailProperties(List<JavamailProperty> properties) {
        if (properties == this.m_javamailProperties) {
            return;
        }
        this.m_javamailProperties.clear();
        if (properties != null) {
            this.m_javamailProperties.addAll(properties);
        }
    }

    public SendmailHost getSendmailHost() {
        return this.m_sendmailHost;
    }

    public void setSendmailHost(SendmailHost sendmailHost) {
        this.m_sendmailHost = ConfigUtils.assertNotNull(sendmailHost, "sendmail-host");
    }

    public SendmailProtocol getSendmailProtocol() {
        return this.m_sendmailProtocol;
    }

    public void setSendmailProtocol(SendmailProtocol sendmailProtocol) {
        this.m_sendmailProtocol = ConfigUtils.assertNotNull(sendmailProtocol, "sendmail-protocol");
    }

    public SendmailMessage getSendmailMessage() {
        return this.m_sendmailMessage;
    }

    public void setSendmailMessage(SendmailMessage sendmailMessage) {
        this.m_sendmailMessage = ConfigUtils.assertNotNull(sendmailMessage, "sendmail-message");
    }

    public UserAuth getUserAuth() {
        return this.m_userAuth;
    }

    public void setUserAuth(UserAuth userAuth) {
        this.m_userAuth = ConfigUtils.assertNotNull(userAuth, "user-auth");
    }

    public int hashCode() {
        return Objects.hash(this.m_debug, this.m_useAuthentication, this.m_useJmta, this.m_attemptInterval, this.m_name, this.m_javamailProperties, this.m_sendmailHost, this.m_sendmailProtocol, this.m_sendmailMessage, this.m_userAuth);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SendmailConfig) {
            SendmailConfig that = (SendmailConfig)obj;
            return Objects.equals(this.m_debug, that.m_debug) && Objects.equals(this.m_useAuthentication, that.m_useAuthentication) && Objects.equals(this.m_useJmta, that.m_useJmta) && Objects.equals(this.m_attemptInterval, that.m_attemptInterval) && Objects.equals(this.m_name, that.m_name) && Objects.equals(this.m_javamailProperties, that.m_javamailProperties) && Objects.equals(this.m_sendmailHost, that.m_sendmailHost) && Objects.equals(this.m_sendmailProtocol, that.m_sendmailProtocol) && Objects.equals(this.m_sendmailMessage, that.m_sendmailMessage) && Objects.equals(this.m_userAuth, that.m_userAuth);
        }
        return false;
    }
}

