/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.javamail;

import java.io.Serializable;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="readmail-protocol", namespace="http://xmlns.opennms.org/xsd/config/javamail-configuration")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="javamail-configuration.xsd")
public class ReadmailProtocol
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlAttribute(name="transport")
    private String m_transport;
    @XmlAttribute(name="ssl-enable")
    private Boolean m_sslEnable;
    @XmlAttribute(name="start-tls")
    private Boolean m_startTls;

    public String getTransport() {
        return this.m_transport == null ? "pop3" : this.m_transport;
    }

    public void setTransport(String transport) {
        this.m_transport = ConfigUtils.normalizeString(transport);
    }

    public Boolean isSslEnable() {
        return this.m_sslEnable == null ? Boolean.FALSE : this.m_sslEnable;
    }

    public void setSslEnable(Boolean sslEnable) {
        this.m_sslEnable = sslEnable;
    }

    public Boolean isStartTls() {
        return this.m_startTls == null ? Boolean.FALSE : this.m_startTls;
    }

    public void setStartTls(Boolean startTls) {
        this.m_startTls = startTls;
    }

    public int hashCode() {
        return Objects.hash(this.m_transport, this.m_sslEnable, this.m_startTls);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ReadmailProtocol) {
            ReadmailProtocol that = (ReadmailProtocol)obj;
            return Objects.equals(this.m_transport, that.m_transport) && Objects.equals(this.m_sslEnable, that.m_sslEnable) && Objects.equals(this.m_startTls, that.m_startTls);
        }
        return false;
    }
}

