/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.notificationCommands;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.notificationCommands.Command;
import org.opennms.netmgt.config.notificationCommands.Header;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="notification-commands")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="notificationCommands.xsd")
public class NotificationCommands
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="header", required=true)
    private Header m_header;
    @XmlElement(name="command", required=true)
    private List<Command> m_commands = new ArrayList<Command>();

    public Header getHeader() {
        return this.m_header;
    }

    public void setHeader(Header header) {
        this.m_header = ConfigUtils.assertNotNull(header, "header");
    }

    public List<Command> getCommands() {
        return this.m_commands;
    }

    public void setCommands(List<Command> commands) {
        if (commands == this.m_commands) {
            return;
        }
        this.m_commands.clear();
        if (commands != null) {
            this.m_commands.addAll(commands);
        }
    }

    public void addCommand(Command command) {
        this.m_commands.add(command);
    }

    public boolean removeCommand(Command command) {
        return this.m_commands.remove(command);
    }

    public int hashCode() {
        return Objects.hash(this.m_header, this.m_commands);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof NotificationCommands) {
            NotificationCommands that = (NotificationCommands)obj;
            return Objects.equals(this.m_header, that.m_header) && Objects.equals(this.m_commands, that.m_commands);
        }
        return false;
    }
}

