/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.mailtransporttest;

import java.io.Serializable;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="readmail-protocol")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="mail-transport-test.xsd")
public class ReadmailProtocol
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlAttribute(name="transport")
    private String m_transport;
    @XmlAttribute(name="ssl-enable")
    private Boolean m_sslEnable;
    @XmlAttribute(name="start-tls")
    private Boolean m_startTLS;

    public ReadmailProtocol() {
    }

    public ReadmailProtocol(String transport, Boolean sslEnabled, Boolean startTls) {
        this.setTransport(transport);
        this.setSslEnabled(sslEnabled);
        this.setStartTLS(startTls);
    }

    public String getTransport() {
        return this.m_transport == null ? "pop3" : this.m_transport;
    }

    public void setTransport(String transport) {
        this.m_transport = ConfigUtils.normalizeString(transport);
    }

    public Boolean isSslEnabled() {
        return this.m_sslEnable == null ? false : this.m_sslEnable;
    }

    public void setSslEnabled(Boolean sslEnable) {
        this.m_sslEnable = sslEnable;
    }

    public Boolean shouldStartTLS() {
        return this.m_startTLS == null ? false : this.m_startTLS;
    }

    public void setStartTLS(Boolean startTLS) {
        this.m_startTLS = startTLS;
    }

    public int hashCode() {
        return Objects.hash(this.m_transport, this.m_sslEnable, this.m_startTLS);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ReadmailProtocol) {
            ReadmailProtocol that = (ReadmailProtocol)obj;
            return Objects.equals(this.m_transport, that.m_transport) && Objects.equals(this.m_sslEnable, that.m_sslEnable) && Objects.equals(this.m_startTLS, that.m_startTLS);
        }
        return false;
    }
}

