/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.rancid.adapter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.rancid.adapter.ExcludeRange;
import org.opennms.netmgt.config.rancid.adapter.Filter;
import org.opennms.netmgt.config.rancid.adapter.IncludeRange;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="package")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="rancid-adapter-configuration.xsd")
public class Package
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlAttribute(name="name", required=true)
    private String m_name;
    @XmlElement(name="filter", required=true)
    private Filter m_filter;
    @XmlElement(name="specific")
    private List<String> m_specifics = new ArrayList<String>();
    @XmlElement(name="include-range")
    private List<IncludeRange> m_includeRanges = new ArrayList<IncludeRange>();
    @XmlElement(name="exclude-range")
    private List<ExcludeRange> m_excludeRanges = new ArrayList<ExcludeRange>();
    @XmlElement(name="include-url")
    private List<String> m_includeUrls = new ArrayList<String>();

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = ConfigUtils.assertNotEmpty(name, "name");
    }

    public Filter getFilter() {
        return this.m_filter;
    }

    public void setFilter(Filter filter) {
        this.m_filter = ConfigUtils.assertNotNull(filter, "filter");
    }

    public List<String> getSpecifics() {
        return this.m_specifics;
    }

    public void setSpecifics(List<String> specifics) {
        if (specifics == this.m_specifics) {
            return;
        }
        this.m_specifics.clear();
        if (specifics != null) {
            this.m_specifics.addAll(specifics);
        }
    }

    public void addSpecific(String specific) {
        this.m_specifics.add(specific);
    }

    public boolean removeSpecific(String specific) {
        return this.m_specifics.remove(specific);
    }

    public List<IncludeRange> getIncludeRanges() {
        return this.m_includeRanges;
    }

    public void setIncludeRanges(List<IncludeRange> includeRanges) {
        if (includeRanges == this.m_includeRanges) {
            return;
        }
        this.m_includeRanges.clear();
        if (includeRanges != null) {
            this.m_includeRanges.addAll(includeRanges);
        }
    }

    public void addIncludeRange(IncludeRange includeRange) {
        this.m_includeRanges.add(includeRange);
    }

    public boolean removeIncludeRange(IncludeRange includeRange) {
        return this.m_includeRanges.remove(includeRange);
    }

    public List<ExcludeRange> getExcludeRanges() {
        return this.m_excludeRanges;
    }

    public void setExcludeRanges(List<ExcludeRange> excludeRanges) {
        if (excludeRanges == this.m_excludeRanges) {
            return;
        }
        this.m_excludeRanges.clear();
        if (excludeRanges != null) {
            this.m_excludeRanges.addAll(excludeRanges);
        }
    }

    public void addExcludeRange(ExcludeRange excludeRange) {
        this.m_excludeRanges.add(excludeRange);
    }

    public boolean removeExcludeRange(ExcludeRange excludeRange) {
        return this.m_excludeRanges.remove(excludeRange);
    }

    public List<String> getIncludeUrls() {
        return this.m_includeUrls;
    }

    public void setIncludeUrls(List<String> includeUrls) {
        if (includeUrls == this.m_includeUrls) {
            return;
        }
        this.m_includeUrls.clear();
        if (includeUrls != null) {
            this.m_includeUrls.addAll(includeUrls);
        }
    }

    public void addIncludeUrl(String includeUrl) {
        this.m_includeUrls.add(includeUrl);
    }

    public boolean removeIncludeUrl(String includeUrl) {
        return this.m_includeUrls.remove(includeUrl);
    }

    public int hashCode() {
        return Objects.hash(this.m_name, this.m_filter, this.m_specifics, this.m_includeRanges, this.m_excludeRanges, this.m_includeUrls);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Package) {
            Package that = (Package)obj;
            return Objects.equals(this.m_name, that.m_name) && Objects.equals(this.m_filter, that.m_filter) && Objects.equals(this.m_specifics, that.m_specifics) && Objects.equals(this.m_includeRanges, that.m_includeRanges) && Objects.equals(this.m_excludeRanges, that.m_excludeRanges) && Objects.equals(this.m_includeUrls, that.m_includeUrls);
        }
        return false;
    }
}

