/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.users;

import java.io.Serializable;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.opennms.core.xml.StringTrimAdapter;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.users.Contact;
import org.opennms.netmgt.config.users.Password;
import org.opennms.netmgt.config.users.TimeZoneIdAdapter;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="user")
@XmlAccessorType(value=XmlAccessType.NONE)
@ValidateUsing(value="users.xsd")
@XmlType(propOrder={"m_userId", "m_fullName", "m_userComments", "m_password", "contacts", "dutySchedules", "roles", "m_tuiPin", "m_timeZoneId"})
public class User
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlElement(name="user-id", required=true)
    @XmlJavaTypeAdapter(value=StringTrimAdapter.class)
    private String m_userId;
    @XmlElement(name="full-name")
    @XmlJavaTypeAdapter(value=StringTrimAdapter.class)
    private String m_fullName;
    @XmlElement(name="user-comments")
    @XmlJavaTypeAdapter(value=StringTrimAdapter.class)
    private String m_userComments;
    @XmlElement(name="password", required=true)
    private Password m_password;
    private List<Contact> m_contacts = new ArrayList<Contact>();
    private List<String> m_dutySchedules = new ArrayList<String>();
    private List<String> m_roles = new ArrayList<String>();
    @XmlElement(name="tui-pin")
    @XmlJavaTypeAdapter(value=StringTrimAdapter.class)
    private String m_tuiPin;
    @XmlElement(name="time-zone-id")
    @XmlJavaTypeAdapter(value=TimeZoneIdAdapter.class)
    private ZoneId m_timeZoneId;

    public User() {
    }

    public User(String userId) {
        this.m_userId = userId;
    }

    public User(String userId, String fullName, String userComments) {
        this.setUserId(userId);
        this.setFullName(fullName);
        this.setUserComments(userComments);
    }

    public String getUserId() {
        return this.m_userId;
    }

    public void setUserId(String userId) {
        ConfigUtils.assertNotEmpty(userId, "user-id");
        this.m_userId = userId;
    }

    public Optional<String> getFullName() {
        return Optional.ofNullable(this.m_fullName);
    }

    public void setFullName(String fullName) {
        this.m_fullName = ConfigUtils.normalizeString(fullName);
    }

    public Optional<String> getUserComments() {
        return Optional.ofNullable(this.m_userComments);
    }

    public void setUserComments(String userComments) {
        this.m_userComments = ConfigUtils.normalizeString(userComments);
    }

    public Password getPassword() {
        return this.m_password;
    }

    public void setPassword(Password password) {
        ConfigUtils.assertNotNull(password, "password");
        this.m_password = password;
    }

    public void setPassword(String password, Boolean salt) {
        this.m_password = new Password(password, salt);
    }

    @XmlElement(name="contact")
    public List<Contact> getContacts() {
        return this.m_contacts;
    }

    public void addContact(Contact contact) {
        this.m_contacts.add(contact);
    }

    public void setContacts(List<Contact> contacts) {
        if (this.m_contacts == contacts) {
            return;
        }
        this.m_contacts.clear();
        if (contacts != null) {
            this.m_contacts.addAll(contacts);
        }
    }

    public void clearContacts() {
        this.m_contacts.clear();
    }

    @XmlElement(name="duty-schedule")
    public List<String> getDutySchedules() {
        return this.m_dutySchedules;
    }

    public void setDutySchedules(List<String> dutySchedules) {
        if (this.m_dutySchedules == dutySchedules) {
            return;
        }
        this.m_dutySchedules.clear();
        if (dutySchedules != null) {
            this.m_dutySchedules.addAll(dutySchedules.stream().map(ConfigUtils::normalizeAndTrimString).collect(Collectors.toList()));
        }
    }

    public void addDutySchedule(String dutySchedule) {
        this.m_dutySchedules.add(dutySchedule);
    }

    public void clearDutySchedules() {
        this.m_dutySchedules.clear();
    }

    @XmlElement(name="role")
    public List<String> getRoles() {
        return this.m_roles;
    }

    public void setRoles(List<String> roles) {
        if (roles == this.m_roles) {
            return;
        }
        this.m_roles.clear();
        if (roles != null) {
            this.m_roles.addAll(roles.stream().map(ConfigUtils::normalizeAndTrimString).collect(Collectors.toList()));
        }
    }

    public void addRole(String role) {
        this.m_roles.add(role);
    }

    public void clearRoles() {
        this.m_roles.clear();
    }

    public Optional<String> getTuiPin() {
        return Optional.ofNullable(this.m_tuiPin);
    }

    public void setTuiPin(String tuiPin) {
        this.m_tuiPin = tuiPin;
    }

    public Optional<ZoneId> getTimeZoneId() {
        return Optional.ofNullable(this.m_timeZoneId);
    }

    public void setTimeZoneId(String timeZoneId) {
        this.m_timeZoneId = ZoneId.of(timeZoneId);
    }

    public void setTimeZoneId(ZoneId timeZoneId) {
        this.m_timeZoneId = timeZoneId;
    }

    public int hashCode() {
        return Objects.hash(this.m_userId, this.m_fullName, this.m_userComments, this.m_password, this.m_contacts, this.m_dutySchedules, this.m_roles, this.m_tuiPin, this.m_timeZoneId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof User) {
            User temp = (User)obj;
            return Objects.equals(temp.m_userId, this.m_userId) && Objects.equals(temp.m_fullName, this.m_fullName) && Objects.equals(temp.m_userComments, this.m_userComments) && Objects.equals(temp.m_password, this.m_password) && Objects.equals(temp.m_contacts, this.m_contacts) && Objects.equals(temp.m_dutySchedules, this.m_dutySchedules) && Objects.equals(temp.m_roles, this.m_roles) && Objects.equals(temp.m_tuiPin, this.m_tuiPin) && Objects.equals(temp.m_timeZoneId, this.m_timeZoneId);
        }
        return false;
    }

    public String toString() {
        return "User[userId=" + this.m_userId + ", fullName=" + this.m_fullName + ", userComments=" + this.m_userComments + ", password=" + this.m_password + ", contacts=" + this.m_contacts + ", dutySchedules=" + this.m_dutySchedules + ", roles=" + this.m_roles + ", tuiPin=" + this.m_tuiPin + ", timeZoneId=" + this.m_timeZoneId + "]";
    }
}

