/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.ackd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.ackd.Reader;

@XmlRootElement(name="ackd-configuration")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="ackd-configuration.xsd")
public class AckdConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final boolean DEFAULT_ALARM_SYNC_FLAG = true;
    public static final String DEFAULT_ACK_EXPRESSION = "~(?i)^ack$";
    public static final String DEFAULT_UNACK_EXPRESSION = "~(?i)^unack$";
    public static final String DEFAULT_ESCALATE_EXPRESSION = "~(?i)^esc$";
    public static final String DEFAULT_CLEAR_EXPRESSION = "~(?i)^(resolve|clear)$";
    public static final String DEFAULT_NOTIFYID_MATCH_EXPRESSION = "~(?i).*Re:.*Notice #([0-9]+).*";
    public static final String DEFAULT_ALARMID_MATCH_EXPRESSION = "~(?i).*alarmid:([0-9]+).*";
    @XmlAttribute(name="alarm-sync")
    private Boolean m_alarmSync;
    @XmlAttribute(name="ack-expression")
    private String m_ackExpression;
    @XmlAttribute(name="unack-expression")
    private String m_unackExpression;
    @XmlAttribute(name="escalate-expression")
    private String m_escalateExpression;
    @XmlAttribute(name="clear-expression")
    private String m_clearExpression;
    @XmlAttribute(name="notifyid-match-expression")
    private String m_notifyidMatchExpression;
    @XmlAttribute(name="alarmid-match-expression")
    private String m_alarmidMatchExpression;
    @XmlElementWrapper(name="readers")
    @XmlElement(name="reader")
    private List<Reader> m_readers;

    public AckdConfiguration() {
    }

    public AckdConfiguration(boolean alarmSync, String ackExpression, String unackExpression, String clearExpression, String escalateExpression, String notifyidMatchExpression, String alarmidMatchExpression, List<Reader> readers) {
        this.setAlarmSync(alarmSync);
        this.setAckExpression(ackExpression);
        this.setUnackExpression(unackExpression);
        this.setClearExpression(clearExpression);
        this.setEscalateExpression(escalateExpression);
        this.setNotifyidMatchExpression(notifyidMatchExpression);
        this.setAlarmidMatchExpression(alarmidMatchExpression);
        this.setReaders(readers);
    }

    public boolean getAlarmSync() {
        return this.m_alarmSync == null ? true : this.m_alarmSync;
    }

    public void setAlarmSync(Boolean alarmSync) {
        this.m_alarmSync = alarmSync;
    }

    public String getAckExpression() {
        return this.m_ackExpression == null ? DEFAULT_ACK_EXPRESSION : this.m_ackExpression;
    }

    public void setAckExpression(String ackExpression) {
        this.m_ackExpression = ackExpression;
    }

    public String getUnackExpression() {
        return this.m_unackExpression == null ? DEFAULT_UNACK_EXPRESSION : this.m_unackExpression;
    }

    public void setUnackExpression(String unackExpression) {
        this.m_unackExpression = unackExpression;
    }

    public String getEscalateExpression() {
        return this.m_escalateExpression == null ? DEFAULT_ESCALATE_EXPRESSION : this.m_escalateExpression;
    }

    public void setEscalateExpression(String escalateExpression) {
        this.m_escalateExpression = escalateExpression;
    }

    public String getClearExpression() {
        return this.m_clearExpression == null ? DEFAULT_CLEAR_EXPRESSION : this.m_clearExpression;
    }

    public void setClearExpression(String clearExpression) {
        this.m_clearExpression = clearExpression;
    }

    public String getNotifyidMatchExpression() {
        return this.m_notifyidMatchExpression == null ? DEFAULT_NOTIFYID_MATCH_EXPRESSION : this.m_notifyidMatchExpression;
    }

    public void setNotifyidMatchExpression(String notifyidMatchExpression) {
        this.m_notifyidMatchExpression = notifyidMatchExpression;
    }

    public String getAlarmidMatchExpression() {
        return this.m_alarmidMatchExpression == null ? DEFAULT_ALARMID_MATCH_EXPRESSION : this.m_alarmidMatchExpression;
    }

    public void setAlarmidMatchExpression(String alarmidMatchExpression) {
        this.m_alarmidMatchExpression = alarmidMatchExpression;
    }

    public List<Reader> getReaders() {
        return this.m_readers == null ? Collections.emptyList() : this.m_readers;
    }

    public void setReaders(List<Reader> readers) {
        if (readers == this.m_readers) {
            return;
        }
        if (this.m_readers != null) {
            this.m_readers.clear();
        }
        if (readers != null) {
            if (this.m_readers == null) {
                this.m_readers = new ArrayList<Reader>();
            }
            this.m_readers.addAll(readers);
        }
    }

    public int hashCode() {
        return Objects.hash(this.m_alarmSync, this.m_ackExpression, this.m_unackExpression, this.m_escalateExpression, this.m_clearExpression, this.m_notifyidMatchExpression, this.m_alarmidMatchExpression, this.m_readers);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AckdConfiguration) {
            AckdConfiguration that = (AckdConfiguration)obj;
            return Objects.equals(this.m_alarmSync, that.m_alarmSync) && Objects.equals(this.m_ackExpression, that.m_ackExpression) && Objects.equals(this.m_unackExpression, that.m_unackExpression) && Objects.equals(this.m_escalateExpression, that.m_escalateExpression) && Objects.equals(this.m_clearExpression, that.m_clearExpression) && Objects.equals(this.m_notifyidMatchExpression, that.m_notifyidMatchExpression) && Objects.equals(this.m_alarmidMatchExpression, that.m_alarmidMatchExpression) && Objects.equals(this.m_readers, that.m_readers);
        }
        return false;
    }
}

