/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.siteStatusViews;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.siteStatusViews.View;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="site-status-view-configuration")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="site-status-views.xsd")
public class SiteStatusViewConfiguration
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final String DEFAULT_VIEW = "default";
    @XmlAttribute(name="default-view")
    private String m_defaultView;
    @XmlElementWrapper(name="views", required=true)
    @XmlElement(name="view", required=true)
    private List<View> m_views = new ArrayList<View>();

    public String getDefaultView() {
        return this.m_defaultView != null ? this.m_defaultView : DEFAULT_VIEW;
    }

    public void setDefaultView(String defaultView) {
        this.m_defaultView = ConfigUtils.normalizeString(defaultView);
    }

    public List<View> getViews() {
        return this.m_views;
    }

    public void setViews(List<View> views) {
        if (views == this.m_views) {
            return;
        }
        this.m_views.clear();
        if (views != null) {
            this.m_views.addAll(views);
        }
    }

    public void addView(View view) {
        this.m_views.add(view);
    }

    public boolean removeView(View view) {
        return this.m_views.remove(view);
    }

    public int hashCode() {
        return Objects.hash(this.m_defaultView, this.m_views);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SiteStatusViewConfiguration) {
            SiteStatusViewConfiguration that = (SiteStatusViewConfiguration)obj;
            return Objects.equals(this.m_defaultView, that.m_defaultView) && Objects.equals(this.m_views, that.m_views);
        }
        return false;
    }
}

