/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.ami;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.ami.Definition;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="ami-config")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="ami-config.xsd")
public class AmiConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlAttribute(name="port")
    private Integer m_port;
    @XmlAttribute(name="use-ssl")
    private Boolean m_useSsl;
    @XmlAttribute(name="timeout")
    private Integer m_timeout;
    @XmlAttribute(name="retry")
    private Integer m_retry;
    @XmlAttribute(name="username", required=true)
    private String m_username;
    @XmlAttribute(name="password")
    private String m_password;
    @XmlElement(name="definition")
    private List<Definition> m_definitions = new ArrayList<Definition>();

    public AmiConfig() {
    }

    public AmiConfig(Integer port, Boolean useSsl, Integer timeout, Integer retry, String username, String password, List<Definition> definitions) {
        this.setPort(port);
        this.setUseSsl(useSsl);
        this.setTimeout(timeout);
        this.setRetry(retry);
        this.setUsername(username);
        this.setPassword(password);
        this.setDefinitions(definitions);
    }

    public Integer getPort() {
        return this.m_port == null ? 5038 : this.m_port;
    }

    public void setPort(Integer port) {
        this.m_port = port;
    }

    public Boolean getUseSsl() {
        return this.m_useSsl == null ? false : this.m_useSsl;
    }

    public void setUseSsl(Boolean useSsl) {
        this.m_useSsl = useSsl;
    }

    public Integer getTimeout() {
        return this.m_timeout == null ? 3000 : this.m_timeout;
    }

    public void setTimeout(Integer timeout) {
        this.m_timeout = timeout;
    }

    public Integer getRetry() {
        return this.m_retry == null ? 0 : this.m_retry;
    }

    public void setRetry(Integer retry) {
        this.m_retry = retry;
    }

    public Optional<String> getUsername() {
        return Optional.ofNullable(this.m_username);
    }

    public void setUsername(String username) {
        this.m_username = ConfigUtils.normalizeString(username);
    }

    public Optional<String> getPassword() {
        return Optional.ofNullable(this.m_password);
    }

    public void setPassword(String password) {
        this.m_password = ConfigUtils.normalizeString(password);
    }

    public List<Definition> getDefinitions() {
        return this.m_definitions;
    }

    public void setDefinitions(List<Definition> definitions) {
        if (definitions == this.m_definitions) {
            return;
        }
        this.m_definitions.clear();
        if (definitions != null) {
            this.m_definitions.addAll(definitions);
        }
    }

    public int hashCode() {
        return Objects.hash(this.m_port, this.m_useSsl, this.m_timeout, this.m_retry, this.m_username, this.m_password, this.m_definitions);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AmiConfig) {
            AmiConfig that = (AmiConfig)obj;
            return Objects.equals(this.m_port, that.m_port) && Objects.equals(this.m_useSsl, that.m_useSsl) && Objects.equals(this.m_timeout, that.m_timeout) && Objects.equals(this.m_retry, that.m_retry) && Objects.equals(this.m_username, that.m_username) && Objects.equals(this.m_password, that.m_password) && Objects.equals(this.m_definitions, that.m_definitions);
        }
        return false;
    }
}

