/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.poller.outages;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.xml.ValidateUsing;

@XmlRootElement(name="interface", namespace="http://xmlns.opennms.org/xsd/config/poller/outages")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="poll-outages.xsd")
public class Interface
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlAttribute(name="address")
    private String m_address;

    public String getAddress() {
        return this.m_address;
    }

    public void setAddress(String address) {
        if (!this.isValidAddress(address)) {
            throw new IllegalArgumentException("'address' is a required field and must be either a valid IP address, or 'match-any'!");
        }
        this.m_address = address;
    }

    public int hashCode() {
        return Objects.hash(this.m_address);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Interface) {
            Interface that = (Interface)obj;
            return Objects.equals(this.m_address, that.m_address);
        }
        return false;
    }

    private boolean isValidAddress(String addr) {
        if (addr == null) {
            return false;
        }
        if ("match-any".equals(addr)) {
            return true;
        }
        try {
            InetAddress inetAddr = InetAddressUtils.addr((String)addr);
            if (inetAddr == null) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

