/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.discovery;

import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="include-url")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="discovery-configuration.xsd")
public class IncludeUrl
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlValue
    private String m_url;
    @XmlAttribute(name="location")
    private String m_location;
    @XmlAttribute(name="retries")
    private Integer m_retries;
    @XmlAttribute(name="timeout")
    private Long m_timeout;
    @XmlAttribute(name="foreign-source")
    private String m_foreignSource;

    public IncludeUrl() {
    }

    public IncludeUrl(String url) {
        this.m_url = url;
    }

    public Optional<String> getUrl() {
        return Optional.ofNullable(this.m_url);
    }

    public void setUrl(String url) {
        this.m_url = ConfigUtils.assertNotEmpty(url, "URL");
    }

    public Optional<String> getLocation() {
        return Optional.ofNullable(this.m_location);
    }

    public void setLocation(String location) {
        this.m_location = ConfigUtils.normalizeString(location);
    }

    public Optional<Integer> getRetries() {
        return Optional.ofNullable(this.m_retries);
    }

    public void setRetries(Integer retries) {
        this.m_retries = retries;
    }

    public Optional<Long> getTimeout() {
        return Optional.ofNullable(this.m_timeout);
    }

    public void setTimeout(Long timeout) {
        if (timeout != null && timeout == 0L) {
            throw new IllegalArgumentException("Can't have a 0 timeout!");
        }
        this.m_timeout = timeout;
    }

    public Optional<String> getForeignSource() {
        return Optional.ofNullable(this.m_foreignSource);
    }

    public void setForeignSource(String foreignSource) {
        this.m_foreignSource = ConfigUtils.normalizeString(foreignSource);
    }

    public int hashCode() {
        return Objects.hash(this.m_url, this.m_location, this.m_retries, this.m_timeout, this.m_foreignSource);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IncludeUrl) {
            IncludeUrl temp = (IncludeUrl)obj;
            return Objects.equals(temp.m_url, this.m_url) && Objects.equals(temp.m_location, this.m_location) && Objects.equals(temp.m_retries, this.m_retries) && Objects.equals(temp.m_timeout, this.m_timeout) && Objects.equals(temp.m_foreignSource, this.m_foreignSource);
        }
        return false;
    }

    public String toString() {
        return "IncludeUrl [value=" + this.m_url + ", location=" + this.m_location + ", retries=" + this.m_retries + ", timeout=" + this.m_timeout + ", foreignSource=" + this.m_foreignSource + "]";
    }
}

