/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.javamail;

import java.io.Serializable;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.javamail.ReadmailProtocol;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="readmail-host", namespace="http://xmlns.opennms.org/xsd/config/javamail-configuration")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="javamail-configuration.xsd")
public class ReadmailHost
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlAttribute(name="host")
    private String m_host;
    @XmlAttribute(name="port")
    private Integer m_port;
    @XmlElement(name="readmail-protocol", required=true)
    private ReadmailProtocol m_readmailProtocol;

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ReadmailHost) {
            ReadmailHost that = (ReadmailHost)obj;
            return Objects.equals(this.m_host, that.m_host) && Objects.equals(this.m_port, that.m_port) && Objects.equals(this.m_readmailProtocol, that.m_readmailProtocol);
        }
        return false;
    }

    public String getHost() {
        return this.m_host == null ? "127.0.0.1" : this.m_host;
    }

    public Integer getPort() {
        return this.m_port == null ? 110 : this.m_port;
    }

    public ReadmailProtocol getReadmailProtocol() {
        return this.m_readmailProtocol;
    }

    public int hashCode() {
        return Objects.hash(this.m_host, this.m_port, this.m_readmailProtocol);
    }

    public void setHost(String host) {
        this.m_host = ConfigUtils.normalizeString(host);
    }

    public void setPort(Integer port) {
        this.m_port = port;
    }

    public void setReadmailProtocol(ReadmailProtocol readmailProtocol) {
        this.m_readmailProtocol = ConfigUtils.assertNotNull(readmailProtocol, "readmail-protocol");
    }
}

