/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.tl1d;

import java.io.Serializable;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="tl1-element")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="tl1d-configuration.xsd")
public class Tl1Element
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_USERID = "opennms";
    private static final String DEFAULT_PASSWORD = "opennms";
    private static final String DEFAULT_TL1_CLIENT_API = "org.opennms.netmgt.tl1d.Tl1ClientImpl";
    private static final String DEFAULT_TL1_MESSAGE_PARSER = "org.opennms.netmgt.tl1d.Tl1AutonomousMessageProcessor";
    @XmlAttribute(name="host", required=true)
    private String m_host;
    @XmlAttribute(name="port")
    private Integer m_port;
    @XmlAttribute(name="userid")
    private String m_userid;
    @XmlAttribute(name="password")
    private String m_password;
    @XmlAttribute(name="tl1-client-api")
    private String m_tl1ClientApi;
    @XmlAttribute(name="tl1-message-parser")
    private String m_tl1MessageParser;
    @XmlAttribute(name="reconnect-delay")
    private Long m_reconnectDelay;

    public String getHost() {
        return this.m_host;
    }

    public void setHost(String host) {
        this.m_host = ConfigUtils.assertNotEmpty(host, "host");
    }

    public Integer getPort() {
        return this.m_port != null ? this.m_port : 502;
    }

    public void setPort(Integer port) {
        this.m_port = port;
    }

    public String getUserid() {
        return this.m_userid != null ? this.m_userid : "opennms";
    }

    public void setUserid(String userid) {
        this.m_userid = ConfigUtils.normalizeAndTrimString(userid);
    }

    public String getPassword() {
        return this.m_password != null ? this.m_password : "opennms";
    }

    public void setPassword(String password) {
        this.m_password = ConfigUtils.normalizeString(password);
    }

    public String getTl1ClientApi() {
        return this.m_tl1ClientApi != null ? this.m_tl1ClientApi : DEFAULT_TL1_CLIENT_API;
    }

    public void setTl1ClientApi(String tl1ClientApi) {
        this.m_tl1ClientApi = ConfigUtils.normalizeString(tl1ClientApi);
    }

    public String getTl1MessageParser() {
        return this.m_tl1MessageParser != null ? this.m_tl1MessageParser : DEFAULT_TL1_MESSAGE_PARSER;
    }

    public void setTl1MessageParser(String tl1MessageParser) {
        this.m_tl1MessageParser = ConfigUtils.normalizeString(tl1MessageParser);
    }

    public Long getReconnectDelay() {
        return this.m_reconnectDelay != null ? this.m_reconnectDelay : 30000L;
    }

    public void setReconnectDelay(Long reconnectDelay) {
        this.m_reconnectDelay = reconnectDelay;
    }

    public int hashCode() {
        return Objects.hash(this.m_host, this.m_port, this.m_userid, this.m_password, this.m_tl1ClientApi, this.m_tl1MessageParser, this.m_reconnectDelay);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Tl1Element) {
            Tl1Element that = (Tl1Element)obj;
            return Objects.equals(this.m_host, that.m_host) && Objects.equals(this.m_port, that.m_port) && Objects.equals(this.m_userid, that.m_userid) && Objects.equals(this.m_password, that.m_password) && Objects.equals(this.m_tl1ClientApi, that.m_tl1ClientApi) && Objects.equals(this.m_tl1MessageParser, that.m_tl1MessageParser) && Objects.equals(this.m_reconnectDelay, that.m_reconnectDelay);
        }
        return false;
    }
}

