/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.vacuumd;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.utils.ConfigUtils;
import org.opennms.netmgt.config.vacuumd.Statement;

@XmlRootElement(name="trigger")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="vacuumd-configuration.xsd")
public class Trigger
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final List<String> ALLOWED_OPERATORS = Arrays.asList("<", "<=", "=", ">=", ">");
    public static final String DEFAULT_DATA_SOURCE = "opennms";
    public static final Integer DEFAULT_ROW_COUNT = 0;
    @XmlAttribute(name="name", required=true)
    private String m_name;
    @XmlAttribute(name="data-source")
    private String m_dataSource;
    @XmlAttribute(name="operator")
    private String m_operator;
    @XmlAttribute(name="row-count")
    private Integer m_rowCount;
    @XmlElement(name="statement", required=true)
    private Statement m_statement;

    public Trigger() {
    }

    public Trigger(String name, String dataSource, String operator, Integer rowCount, Statement statement) {
        this.setName(name);
        this.setDataSource(dataSource);
        this.setOperator(operator);
        this.setRowCount(rowCount);
        this.setStatement(statement);
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = ConfigUtils.assertNotEmpty(name, "name");
    }

    public String getDataSource() {
        return this.m_dataSource == null ? DEFAULT_DATA_SOURCE : this.m_dataSource;
    }

    public void setDataSource(String dataSource) {
        this.m_dataSource = ConfigUtils.normalizeString(dataSource);
    }

    public String getOperator() {
        return this.m_operator;
    }

    public void setOperator(String operator) {
        this.m_operator = ConfigUtils.assertOnlyContains(ConfigUtils.normalizeString(operator), ALLOWED_OPERATORS, "operator");
    }

    public Integer getRowCount() {
        return this.m_rowCount == null ? DEFAULT_ROW_COUNT : this.m_rowCount;
    }

    public void setRowCount(Integer rowCount) {
        this.m_rowCount = rowCount;
    }

    public Statement getStatement() {
        return this.m_statement;
    }

    public void setStatement(Statement statement) {
        this.m_statement = ConfigUtils.assertNotNull(statement, "statement");
    }

    public int hashCode() {
        return Objects.hash(this.m_name, this.m_dataSource, this.m_operator, this.m_rowCount, this.m_statement);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Trigger) {
            Trigger that = (Trigger)obj;
            return Objects.equals(this.m_name, that.m_name) && Objects.equals(this.m_dataSource, that.m_dataSource) && Objects.equals(this.m_operator, that.m_operator) && Objects.equals(this.m_rowCount, that.m_rowCount) && Objects.equals(this.m_statement, that.m_statement);
        }
        return false;
    }
}

