/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.surveillanceViews;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.surveillanceViews.Category;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="column-def")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="surveillance-views.xsd")
public class ColumnDef
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlAttribute(name="label", required=true)
    private String m_label;
    @XmlAttribute(name="report-category")
    private String m_reportCategory;
    @XmlElement(name="category", required=true)
    private List<Category> m_categories = new ArrayList<Category>();

    public ColumnDef() {
    }

    public ColumnDef(String label, String ... categories) {
        this.setLabel(label);
        for (String category : categories) {
            this.addCategory(category);
        }
    }

    public String getLabel() {
        return this.m_label;
    }

    public void setLabel(String label) {
        this.m_label = ConfigUtils.assertNotEmpty(label, "label");
    }

    public Optional<String> getReportCategory() {
        return Optional.ofNullable(this.m_reportCategory);
    }

    public void setReportCategory(String reportCategory) {
        this.m_reportCategory = ConfigUtils.normalizeString(reportCategory);
    }

    public List<Category> getCategories() {
        return this.m_categories;
    }

    public void setCategories(List<Category> categories) {
        ConfigUtils.assertMinimumSize(categories, 1L, "category");
        if (categories == this.m_categories) {
            return;
        }
        this.m_categories.clear();
        if (categories != null) {
            this.m_categories.addAll(categories);
        }
    }

    public void addCategory(Category vCategory) {
        this.m_categories.add(vCategory);
    }

    public void addCategory(String category) {
        this.m_categories.add(new Category(category));
    }

    public boolean removeCategory(Category category) {
        return this.m_categories.remove(category);
    }

    public int hashCode() {
        return Objects.hash(this.m_label, this.m_reportCategory, this.m_categories);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ColumnDef) {
            ColumnDef that = (ColumnDef)obj;
            return Objects.equals(this.m_label, that.m_label) && Objects.equals(this.m_reportCategory, that.m_reportCategory) && Objects.equals(this.m_categories, that.m_categories);
        }
        return false;
    }
}

