/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.groups;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="group")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="groups.xsd")
public class Group
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="name", required=true)
    private String m_name;
    @XmlElement(name="default-map")
    private String m_defaultMap;
    @XmlElement(name="comments")
    private String m_comments;
    @XmlElement(name="user")
    private List<String> m_users = new ArrayList<String>();
    @XmlElement(name="duty-schedule")
    private List<String> m_dutySchedules = new ArrayList<String>();

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = ConfigUtils.assertNotEmpty(name, "name");
    }

    public Optional<String> getDefaultMap() {
        return Optional.ofNullable(this.m_defaultMap);
    }

    public void setDefaultMap(String defaultMap) {
        this.m_defaultMap = ConfigUtils.normalizeString(defaultMap);
    }

    public Optional<String> getComments() {
        return Optional.ofNullable(this.m_comments);
    }

    public void setComments(String comments) {
        this.m_comments = ConfigUtils.normalizeString(comments);
    }

    public List<String> getUsers() {
        return this.m_users;
    }

    public void setUsers(List<String> users) {
        if (users == this.m_users) {
            return;
        }
        this.m_users.clear();
        if (users != null) {
            this.m_users.addAll(users);
        }
    }

    public void addUser(String user) {
        this.m_users.add(user);
    }

    public boolean removeUser(String user) {
        return this.m_users.remove(user);
    }

    public void clearUsers() {
        this.m_users.clear();
    }

    public List<String> getDutySchedules() {
        return this.m_dutySchedules;
    }

    public void setDutySchedules(List<String> dutySchedules) {
        if (dutySchedules == this.m_dutySchedules) {
            return;
        }
        this.m_dutySchedules.clear();
        if (dutySchedules != null) {
            this.m_dutySchedules.addAll(dutySchedules);
        }
    }

    public void addDutySchedule(String dutySchedule) {
        this.m_dutySchedules.add(dutySchedule);
    }

    public void clearDutySchedules() {
        this.m_dutySchedules.clear();
    }

    public int hashCode() {
        return Objects.hash(this.m_name, this.m_defaultMap, this.m_comments, this.m_users, this.m_dutySchedules);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Group) {
            Group that = (Group)obj;
            return Objects.equals(this.m_name, that.m_name) && Objects.equals(this.m_defaultMap, that.m_defaultMap) && Objects.equals(this.m_comments, that.m_comments) && Objects.equals(this.m_users, that.m_users) && Objects.equals(this.m_dutySchedules, that.m_dutySchedules);
        }
        return false;
    }

    public String toString() {
        return "Group [name=" + this.m_name + ", defaultMap=" + this.m_defaultMap + ", comments=" + this.m_comments + ", users=" + this.m_users + ", dutySchedules=" + this.m_dutySchedules + "]";
    }
}

