/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.xml.eventconf;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.xml.eventconf.Event;
import org.opennms.netmgt.xml.eventconf.EventOrdering;
import org.opennms.netmgt.xml.eventconf.Global;
import org.opennms.netmgt.xml.eventconf.Partition;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.orm.ObjectRetrievalFailureException;
import org.springframework.util.StringUtils;

@XmlRootElement(name="events")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="eventconf.xsd")
@XmlType(propOrder={})
public class Events
implements Serializable {
    private static final long serialVersionUID = -3725006529763434264L;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Event[] EMPTY_EVENT_ARRAY = new Event[0];
    @XmlElement(name="global", required=false)
    private Global m_global;
    @XmlElement(name="event", required=false)
    private List<Event> m_events = new ArrayList<Event>();
    @XmlElement(name="event-file", required=false)
    private List<String> m_eventFiles = new ArrayList<String>();
    @XmlTransient
    private Map<String, Events> m_loadedEventFiles = new LinkedHashMap<String, Events>();
    @XmlTransient
    private Partition m_partition;
    @XmlTransient
    private Map<String, List<Event>> m_partitionedEvents;
    @XmlTransient
    private List<Event> m_nullPartitionedEvents;
    @XmlTransient
    private Map<String, Event> m_eventsByUei = new HashMap<String, Event>();
    @XmlTransient
    private List<Event> m_wildcardEvents;
    @XmlTransient
    private EventOrdering m_ordering;

    public EventOrdering getOrdering() {
        return this.m_ordering;
    }

    public void addEvent(Event event) throws IndexOutOfBoundsException {
        this.m_events.add(event);
    }

    public void addEvent(int index, Event event) throws IndexOutOfBoundsException {
        this.m_events.add(index, event);
    }

    public void addEventFile(String eventFile) throws IndexOutOfBoundsException {
        this.m_eventFiles.add(eventFile.intern());
    }

    public void addEventFile(int index, String eventFile) throws IndexOutOfBoundsException {
        this.m_eventFiles.add(index, eventFile.intern());
    }

    public Enumeration<Event> enumerateEvent() {
        return Collections.enumeration(this.m_events);
    }

    public Enumeration<String> enumerateEventFile() {
        return Collections.enumeration(this.m_eventFiles);
    }

    public Event getEvent(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.m_events.size()) {
            throw new IndexOutOfBoundsException("getEvent: Index value '" + index + "' not in range [0.." + (this.m_events.size() - 1) + "]");
        }
        return this.m_events.get(index);
    }

    public Event[] getEvent() {
        return this.m_events.toArray(EMPTY_EVENT_ARRAY);
    }

    public List<Event> getEventCollection() {
        return this.m_events;
    }

    public int getEventCount() {
        return this.m_events.size();
    }

    public String getEventFile(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.m_eventFiles.size()) {
            throw new IndexOutOfBoundsException("getEventFile: Index value '" + index + "' not in range [0.." + (this.m_eventFiles.size() - 1) + "]");
        }
        return this.m_eventFiles.get(index);
    }

    public String[] getEventFile() {
        return this.m_eventFiles.toArray(EMPTY_STRING_ARRAY);
    }

    public List<String> getEventFileCollection() {
        return this.m_eventFiles;
    }

    public int getEventFileCount() {
        return this.m_eventFiles.size();
    }

    public Global getGlobal() {
        return this.m_global;
    }

    public boolean isValid() {
        return true;
    }

    public Iterator<Event> iterateEvent() {
        return this.m_events.iterator();
    }

    public Iterator<String> iterateEventFile() {
        return this.m_eventFiles.iterator();
    }

    public void marshal(Writer out) {
        JaxbUtils.marshal((Object)this, (Writer)out);
    }

    public void removeAllEvent() {
        this.m_events.clear();
    }

    public void removeAllEventFile() {
        this.m_eventFiles.clear();
    }

    public boolean removeEvent(Event event) {
        return this.m_events.remove(event);
    }

    public Event removeEventAt(int index) {
        return this.m_events.remove(index);
    }

    public boolean removeEventFile(String eventFile) {
        return this.m_eventFiles.remove(eventFile);
    }

    public String removeEventFileAt(int index) {
        return this.m_eventFiles.remove(index);
    }

    public void setEvent(int index, Event event) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.m_events.size()) {
            throw new IndexOutOfBoundsException("setEvent: Index value '" + index + "' not in range [0.." + (this.m_events.size() - 1) + "]");
        }
        this.m_events.set(index, event);
    }

    public void setEvent(Event[] events) {
        this.m_events.clear();
        for (Event event : events) {
            this.m_events.add(event);
        }
    }

    public void setEvent(List<Event> events) {
        if (this.m_events == events) {
            return;
        }
        this.m_events.clear();
        this.m_events.addAll(events);
    }

    public void setEventCollection(List<Event> events) {
        this.setEvent(events);
    }

    public void setEventFile(int index, String eventFile) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.m_eventFiles.size()) {
            throw new IndexOutOfBoundsException("setEventFile: Index value '" + index + "' not in range [0.." + (this.m_eventFiles.size() - 1) + "]");
        }
        this.m_eventFiles.set(index, eventFile.intern());
    }

    public void setEventFile(String[] eventFiles) {
        this.m_eventFiles.clear();
        for (String eventFile : eventFiles) {
            this.m_eventFiles.add(eventFile.intern());
        }
    }

    public void setEventFile(List<String> eventFiles) {
        if (this.m_eventFiles == eventFiles) {
            return;
        }
        this.m_eventFiles.clear();
        this.m_eventFiles.addAll(eventFiles);
    }

    public void setEventFileCollection(List<String> eventFiles) {
        this.setEventFile(eventFiles);
    }

    public void setGlobal(Global global) {
        this.m_global = global;
    }

    public static Events unmarshal(Reader reader) {
        return (Events)JaxbUtils.unmarshal(Events.class, (Reader)reader);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_eventFiles == null ? 0 : this.m_eventFiles.hashCode());
        result = 31 * result + (this.m_events == null ? 0 : this.m_events.hashCode());
        result = 31 * result + (this.m_global == null ? 0 : this.m_global.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Events)) {
            return false;
        }
        Events other = (Events)obj;
        if (this.m_eventFiles == null ? other.m_eventFiles != null : !this.m_eventFiles.equals(other.m_eventFiles)) {
            return false;
        }
        if (this.m_events == null ? other.m_events != null : !this.m_events.equals(other.m_events)) {
            return false;
        }
        return !(this.m_global == null ? other.m_global != null : !this.m_global.equals(other.m_global));
    }

    Resource getRelative(Resource baseRef, String relative) {
        try {
            if (relative.startsWith("classpath:")) {
                DefaultResourceLoader loader = new DefaultResourceLoader();
                return loader.getResource(relative);
            }
            return baseRef.createRelative(relative);
        }
        catch (IOException e) {
            throw new ObjectRetrievalFailureException(Resource.class, (Object)baseRef, "Resource location has a relative path, however the configResource does not reference a file, so the relative path cannot be resolved.  The location is: " + relative, null);
        }
    }

    public Map<String, Long> loadEventFiles(Resource configResource) throws IOException {
        LinkedHashMap<String, Long> lastModifiedEventFiles = new LinkedHashMap<String, Long>();
        this.loadEventFilesIfModified(configResource, lastModifiedEventFiles);
        return lastModifiedEventFiles;
    }

    public void loadEventFilesIfModified(Resource configResource, Map<String, Long> lastModifiedEventFiles) throws IOException {
        Iterator<Map.Entry<String, Events>> it = this.m_loadedEventFiles.entrySet().iterator();
        while (it.hasNext()) {
            String eventFile = it.next().getKey();
            if (this.m_eventFiles.contains(eventFile)) continue;
            it.remove();
        }
        for (String eventFile : this.m_eventFiles) {
            Resource eventResource = this.getRelative(configResource, eventFile);
            long lastModified = eventResource.lastModified();
            boolean shouldLoadFile = true;
            if (lastModifiedEventFiles.containsKey(eventFile) && lastModifiedEventFiles.get(eventFile) == lastModified) {
                shouldLoadFile = false;
                assert (this.m_loadedEventFiles.containsKey(eventFile));
            }
            if (!shouldLoadFile) continue;
            lastModifiedEventFiles.put(eventFile, lastModified);
            Events events = (Events)JaxbUtils.unmarshal(Events.class, (Resource)eventResource);
            if (events.getEventCount() <= 0) {
                throw new IllegalStateException("Uh oh! An event file " + eventResource.getFile() + " with no events has been laoded!");
            }
            if (events.getGlobal() != null) {
                throw new ObjectRetrievalFailureException(Resource.class, (Object)eventResource, "The event resource " + eventResource + " included from the root event configuration file cannot have a 'global' element", null);
            }
            if (events.getEventFileCollection().size() > 0) {
                throw new ObjectRetrievalFailureException(Resource.class, (Object)eventResource, "The event resource " + eventResource + " included from the root event configuration file cannot include other configuration files: " + StringUtils.collectionToCommaDelimitedString(events.getEventFileCollection()), null);
            }
            this.m_loadedEventFiles.put(eventFile, events);
        }
    }

    public boolean isSecureTag(String tag) {
        return this.m_global == null ? false : this.m_global.isSecureTag(tag);
    }

    private void partitionEvents(Partition partition) {
        this.m_partition = partition;
        this.m_partitionedEvents = new LinkedHashMap<String, List<Event>>();
        this.m_nullPartitionedEvents = new ArrayList<Event>();
        for (Event event : this.m_events) {
            List<String> keys = partition.group(event);
            if (keys == null) {
                this.m_nullPartitionedEvents.add(event);
                continue;
            }
            for (String key : keys) {
                List<Event> events = this.m_partitionedEvents.get(key);
                if (events == null) {
                    events = new ArrayList<Event>(1);
                    this.m_partitionedEvents.put(key, events);
                }
                events.add(event);
            }
        }
    }

    public Event findFirstMatchingEvent(org.opennms.netmgt.xml.event.Event matchingEvent) {
        List<Event> events;
        Event matchedEvent;
        String ueiToMatch = matchingEvent.getUei();
        if (ueiToMatch != null && (matchedEvent = this.m_eventsByUei.get(ueiToMatch)) != null) {
            return matchedEvent;
        }
        String key = this.m_partition.group(matchingEvent);
        SequencedCollection<Event> potentialMatches = this.m_nullPartitionedEvents;
        if (key != null && (events = this.m_partitionedEvents.get(key)) != null) {
            potentialMatches = new TreeSet<Event>(this.m_nullPartitionedEvents);
            potentialMatches.addAll(events);
        }
        for (Event event : potentialMatches) {
            if (!event.matches(matchingEvent)) continue;
            return event;
        }
        for (Map.Entry entry : this.m_loadedEventFiles.entrySet()) {
            Events subEvents = (Events)entry.getValue();
            Event event = subEvents.findFirstMatchingEvent(matchingEvent);
            if (event == null) continue;
            return event;
        }
        return null;
    }

    public Event findFirstMatchingEvent(EventCriteria criteria) {
        for (Event event : this.m_events) {
            if (!criteria.matches(event)) continue;
            return event;
        }
        for (Map.Entry entry : this.m_loadedEventFiles.entrySet()) {
            Events events = (Events)entry.getValue();
            Event result = events.findFirstMatchingEvent(criteria);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public <T> T forEachEvent(T initial, EventCallback<T> callback) {
        T result = initial;
        for (Event event : this.m_events) {
            result = callback.process(result, event);
        }
        for (Map.Entry entry : this.m_loadedEventFiles.entrySet()) {
            Events events = (Events)entry.getValue();
            result = events.forEachEvent(result, callback);
        }
        return result;
    }

    public void initialize(Partition partition, EventOrdering eventOrdering) {
        this.m_ordering = eventOrdering;
        for (Event event : this.m_events) {
            event.initialize(this.m_ordering.next());
        }
        this.partitionEvents(partition);
        for (Map.Entry entry : this.m_loadedEventFiles.entrySet()) {
            Events events = (Events)entry.getValue();
            events.initialize(partition, this.m_ordering.subsequence());
        }
        this.indexEventsByUei();
    }

    private void indexEventsByUei() {
        this.m_eventsByUei.clear();
        HashSet<String> filesProcessed = new HashSet<String>();
        this.indexEventsByUei(this, filesProcessed);
    }

    private void indexEventsByUei(Events eventFile, Set<String> filesProcessed) {
        for (Event event : eventFile.m_events) {
            String uei = event.getUei();
            if (uei == null) continue;
            this.m_eventsByUei.putIfAbsent(uei, event);
        }
        for (Map.Entry entry : this.m_loadedEventFiles.entrySet()) {
            if (filesProcessed.contains(entry.getKey())) continue;
            filesProcessed.add((String)entry.getKey());
            this.indexEventsByUei((Events)entry.getValue(), filesProcessed);
        }
    }

    public Events getLoadEventsByFile(String relativePath) {
        return this.m_loadedEventFiles.get(relativePath);
    }

    public void addLoadedEventFile(String relativePath, Events events) {
        if (!this.m_eventFiles.contains(relativePath)) {
            this.m_eventFiles.add(relativePath);
        }
        this.m_loadedEventFiles.put(relativePath, events);
    }

    public void removeLoadedEventFile(String relativePath) {
        this.m_eventFiles.remove(relativePath);
        this.m_loadedEventFiles.remove(relativePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveEvents(Resource resource) {
        StringWriter stringWriter = new StringWriter();
        JaxbUtils.marshal((Object)this, (Writer)stringWriter);
        if (stringWriter.toString() != null) {
            File file;
            try {
                file = resource.getFile();
            }
            catch (IOException e) {
                throw new DataAccessResourceFailureException("Event resource '" + resource + "' is not a file resource and cannot be saved.  Nested exception: " + e, (Throwable)e);
            }
            Writer fileWriter = null;
            try {
                try {
                    fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);
                }
                catch (IOException e) {
                    throw new DataAccessResourceFailureException("Event file '" + file + "' could not be opened.  Nested exception: " + e, (Throwable)e);
                }
                try {
                    fileWriter.write(stringWriter.toString());
                }
                catch (IOException e) {
                    throw new DataAccessResourceFailureException("Event file '" + file + "' could not be written to.  Nested exception: " + e, (Throwable)e);
                }
                try {
                    fileWriter.close();
                }
                catch (IOException e) {
                    throw new DataAccessResourceFailureException("Event file '" + file + "' could not be closed.  Nested exception: " + e, (Throwable)e);
                }
            }
            finally {
                if (fileWriter != null) {
                    try {
                        fileWriter.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public void save(Resource resource) {
        for (Map.Entry<String, Events> entry : this.m_loadedEventFiles.entrySet()) {
            String eventFile = entry.getKey();
            Events events = entry.getValue();
            Resource eventResource = this.getRelative(resource, eventFile);
            events.save(eventResource);
        }
        this.saveEvents(resource);
    }

    public static interface EventCriteria {
        public boolean matches(Event var1);
    }

    public static interface EventCallback<T> {
        public T process(T var1, Event var2);
    }
}

