/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.wmi.agent;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.config.wmi.agent.Range;

@XmlRootElement(name="definition")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Definition
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlAttribute(name="retry")
    private Integer retry;
    @XmlAttribute(name="timeout")
    private Integer timeout;
    @XmlAttribute(name="username")
    private String username;
    @XmlAttribute(name="domain")
    private String domain;
    @XmlAttribute(name="password")
    private String password;
    @XmlElement(name="range")
    private List<Range> rangeList = new ArrayList<Range>();
    @XmlElement(name="specific")
    private List<String> specificList = new ArrayList<String>();
    @XmlElement(name="ip-match")
    private List<String> ipMatchList = new ArrayList<String>();

    public void addIpMatch(String vIpMatch) throws IndexOutOfBoundsException {
        this.ipMatchList.add(vIpMatch);
    }

    public void addIpMatch(int index, String vIpMatch) throws IndexOutOfBoundsException {
        this.ipMatchList.add(index, vIpMatch);
    }

    public void addRange(Range vRange) throws IndexOutOfBoundsException {
        this.rangeList.add(vRange);
    }

    public void addRange(int index, Range vRange) throws IndexOutOfBoundsException {
        this.rangeList.add(index, vRange);
    }

    public void addSpecific(String vSpecific) throws IndexOutOfBoundsException {
        this.specificList.add(vSpecific);
    }

    public void addSpecific(int index, String vSpecific) throws IndexOutOfBoundsException {
        this.specificList.add(index, vSpecific);
    }

    public void deleteRetry() {
        this.retry = null;
    }

    public void deleteTimeout() {
        this.timeout = null;
    }

    public Enumeration<String> enumerateIpMatch() {
        return Collections.enumeration(this.ipMatchList);
    }

    public Enumeration<Range> enumerateRange() {
        return Collections.enumeration(this.rangeList);
    }

    public Enumeration<String> enumerateSpecific() {
        return Collections.enumeration(this.specificList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Definition) {
            Definition temp = (Definition)obj;
            boolean equals = Objects.equals(temp.retry, this.retry) && Objects.equals(temp.timeout, this.timeout) && Objects.equals(temp.username, this.username) && Objects.equals(temp.domain, this.domain) && Objects.equals(temp.password, this.password) && Objects.equals(temp.rangeList, this.rangeList) && Objects.equals(temp.specificList, this.specificList) && Objects.equals(temp.ipMatchList, this.ipMatchList);
            return equals;
        }
        return false;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getIpMatch(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.ipMatchList.size()) {
            throw new IndexOutOfBoundsException("getIpMatch: Index value '" + index + "' not in range [0.." + (this.ipMatchList.size() - 1) + "]");
        }
        return this.ipMatchList.get(index);
    }

    public String[] getIpMatch() {
        String[] array = new String[]{};
        return this.ipMatchList.toArray(array);
    }

    public List<String> getIpMatchCollection() {
        return this.ipMatchList;
    }

    public int getIpMatchCount() {
        return this.ipMatchList.size();
    }

    public String getPassword() {
        return this.password;
    }

    public Range getRange(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.rangeList.size()) {
            throw new IndexOutOfBoundsException("getRange: Index value '" + index + "' not in range [0.." + (this.rangeList.size() - 1) + "]");
        }
        return this.rangeList.get(index);
    }

    public Range[] getRange() {
        Range[] array = new Range[]{};
        return this.rangeList.toArray(array);
    }

    public List<Range> getRangeCollection() {
        return this.rangeList;
    }

    public int getRangeCount() {
        return this.rangeList.size();
    }

    public Integer getRetry() {
        return this.retry != null ? this.retry : 1;
    }

    public String getSpecific(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.specificList.size()) {
            throw new IndexOutOfBoundsException("getSpecific: Index value '" + index + "' not in range [0.." + (this.specificList.size() - 1) + "]");
        }
        return this.specificList.get(index);
    }

    public String[] getSpecific() {
        String[] array = new String[]{};
        return this.specificList.toArray(array);
    }

    public List<String> getSpecificCollection() {
        return this.specificList;
    }

    public int getSpecificCount() {
        return this.specificList.size();
    }

    public Integer getTimeout() {
        return this.timeout != null ? this.timeout : 3000;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean hasRetry() {
        return this.retry != null;
    }

    public boolean hasTimeout() {
        return this.timeout != null;
    }

    public int hashCode() {
        int hash = Objects.hash(this.retry, this.timeout, this.username, this.domain, this.password, this.rangeList, this.specificList, this.ipMatchList);
        return hash;
    }

    public Iterator<String> iterateIpMatch() {
        return this.ipMatchList.iterator();
    }

    public Iterator<Range> iterateRange() {
        return this.rangeList.iterator();
    }

    public Iterator<String> iterateSpecific() {
        return this.specificList.iterator();
    }

    public void removeAllIpMatch() {
        this.ipMatchList.clear();
    }

    public void removeAllRange() {
        this.rangeList.clear();
    }

    public void removeAllSpecific() {
        this.specificList.clear();
    }

    public boolean removeIpMatch(String vIpMatch) {
        boolean removed = this.ipMatchList.remove(vIpMatch);
        return removed;
    }

    public String removeIpMatchAt(int index) {
        String obj = this.ipMatchList.remove(index);
        return obj;
    }

    public boolean removeRange(Range vRange) {
        boolean removed = this.rangeList.remove(vRange);
        return removed;
    }

    public Range removeRangeAt(int index) {
        Range obj = this.rangeList.remove(index);
        return obj;
    }

    public boolean removeSpecific(String vSpecific) {
        boolean removed = this.specificList.remove(vSpecific);
        return removed;
    }

    public String removeSpecificAt(int index) {
        String obj = this.specificList.remove(index);
        return obj;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setIpMatch(int index, String vIpMatch) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.ipMatchList.size()) {
            throw new IndexOutOfBoundsException("setIpMatch: Index value '" + index + "' not in range [0.." + (this.ipMatchList.size() - 1) + "]");
        }
        this.ipMatchList.set(index, vIpMatch);
    }

    public void setIpMatch(String[] vIpMatchArray) {
        this.ipMatchList.clear();
        for (int i = 0; i < vIpMatchArray.length; ++i) {
            this.ipMatchList.add(vIpMatchArray[i]);
        }
    }

    public void setIpMatch(List<String> vIpMatchList) {
        this.ipMatchList.clear();
        this.ipMatchList.addAll(vIpMatchList);
    }

    public void setIpMatchCollection(List<String> ipMatchList) {
        this.ipMatchList = ipMatchList;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setRange(int index, Range vRange) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.rangeList.size()) {
            throw new IndexOutOfBoundsException("setRange: Index value '" + index + "' not in range [0.." + (this.rangeList.size() - 1) + "]");
        }
        this.rangeList.set(index, vRange);
    }

    public void setRange(Range[] vRangeArray) {
        this.rangeList.clear();
        for (int i = 0; i < vRangeArray.length; ++i) {
            this.rangeList.add(vRangeArray[i]);
        }
    }

    public void setRange(List<Range> vRangeList) {
        this.rangeList.clear();
        this.rangeList.addAll(vRangeList);
    }

    public void setRangeCollection(List<Range> rangeList) {
        this.rangeList = rangeList;
    }

    public void setRetry(Integer retry) {
        this.retry = retry;
    }

    public void setSpecific(int index, String vSpecific) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.specificList.size()) {
            throw new IndexOutOfBoundsException("setSpecific: Index value '" + index + "' not in range [0.." + (this.specificList.size() - 1) + "]");
        }
        this.specificList.set(index, vSpecific);
    }

    public void setSpecific(String[] vSpecificArray) {
        this.specificList.clear();
        for (int i = 0; i < vSpecificArray.length; ++i) {
            this.specificList.add(vSpecificArray[i]);
        }
    }

    public void setSpecific(List<String> vSpecificList) {
        this.specificList.clear();
        this.specificList.addAll(vSpecificList);
    }

    public void setSpecificCollection(List<String> specificList) {
        this.specificList = specificList;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public void setUsername(String username) {
        this.username = username;
    }
}

