/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.translator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="value")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Value
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlAttribute(name="result", required=true)
    private String result;
    @XmlAttribute(name="matches")
    private String matches;
    @XmlAttribute(name="type", required=true)
    private String type;
    @XmlAttribute(name="name")
    private String name;
    @XmlElement(name="value")
    private List<Value> valueList = new ArrayList<Value>();

    public void addValue(Value vValue) throws IndexOutOfBoundsException {
        this.valueList.add(vValue);
    }

    public void addValue(int index, Value vValue) throws IndexOutOfBoundsException {
        this.valueList.add(index, vValue);
    }

    public Enumeration<Value> enumerateValue() {
        return Collections.enumeration(this.valueList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Value) {
            Value temp = (Value)obj;
            boolean equals = Objects.equals(temp.result, this.result) && Objects.equals(temp.matches, this.matches) && Objects.equals(temp.type, this.type) && Objects.equals(temp.name, this.name) && Objects.equals(temp.valueList, this.valueList);
            return equals;
        }
        return false;
    }

    public String getMatches() {
        return this.matches;
    }

    public String getName() {
        return this.name;
    }

    public String getResult() {
        return this.result;
    }

    public String getType() {
        return this.type;
    }

    public Value getValue(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.valueList.size()) {
            throw new IndexOutOfBoundsException("getValue: Index value '" + index + "' not in range [0.." + (this.valueList.size() - 1) + "]");
        }
        return this.valueList.get(index);
    }

    public Value[] getValue() {
        Value[] array = new Value[]{};
        return this.valueList.toArray(array);
    }

    public List<Value> getValueCollection() {
        return this.valueList;
    }

    public int getValueCount() {
        return this.valueList.size();
    }

    public int hashCode() {
        int hash = Objects.hash(this.result, this.matches, this.type, this.name, this.valueList);
        return hash;
    }

    public Iterator<Value> iterateValue() {
        return this.valueList.iterator();
    }

    public void removeAllValue() {
        this.valueList.clear();
    }

    public boolean removeValue(Value vValue) {
        boolean removed = this.valueList.remove(vValue);
        return removed;
    }

    public Value removeValueAt(int index) {
        Value obj = this.valueList.remove(index);
        return obj;
    }

    public void setMatches(String matches) {
        this.matches = matches;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setValue(int index, Value vValue) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.valueList.size()) {
            throw new IndexOutOfBoundsException("setValue: Index value '" + index + "' not in range [0.." + (this.valueList.size() - 1) + "]");
        }
        this.valueList.set(index, vValue);
    }

    public void setValue(Value[] vValueArray) {
        this.valueList.clear();
        for (int i = 0; i < vValueArray.length; ++i) {
            this.valueList.add(vValueArray[i]);
        }
    }

    public void setValue(List<Value> vValueList) {
        this.valueList.clear();
        this.valueList.addAll(vValueList);
    }

    public void setValueCollection(List<Value> valueList) {
        this.valueList = valueList;
    }
}

