/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.threshd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.config.threshd.Package;
import org.opennms.netmgt.config.threshd.Thresholder;

@XmlRootElement(name="threshd-configuration")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ThreshdConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlAttribute(name="threads", required=true)
    private Integer threads;
    @XmlElement(name="package", required=true)
    private List<Package> _packageList = new ArrayList<Package>();
    @XmlElement(name="thresholder")
    private List<Thresholder> thresholderList = new ArrayList<Thresholder>();

    public void addPackage(Package vPackage) throws IndexOutOfBoundsException {
        this._packageList.add(vPackage);
    }

    public void addPackage(int index, Package vPackage) throws IndexOutOfBoundsException {
        this._packageList.add(index, vPackage);
    }

    public void addThresholder(Thresholder vThresholder) throws IndexOutOfBoundsException {
        this.thresholderList.add(vThresholder);
    }

    public void addThresholder(int index, Thresholder vThresholder) throws IndexOutOfBoundsException {
        this.thresholderList.add(index, vThresholder);
    }

    public void deleteThreads() {
        this.threads = null;
    }

    public Enumeration<Package> enumeratePackage() {
        return Collections.enumeration(this._packageList);
    }

    public Enumeration<Thresholder> enumerateThresholder() {
        return Collections.enumeration(this.thresholderList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ThreshdConfiguration) {
            ThreshdConfiguration temp = (ThreshdConfiguration)obj;
            boolean equals = Objects.equals(temp.threads, this.threads) && Objects.equals(temp._packageList, this._packageList) && Objects.equals(temp.thresholderList, this.thresholderList);
            return equals;
        }
        return false;
    }

    public Package getPackage(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._packageList.size()) {
            throw new IndexOutOfBoundsException("getPackage: Index value '" + index + "' not in range [0.." + (this._packageList.size() - 1) + "]");
        }
        return this._packageList.get(index);
    }

    public Package[] getPackage() {
        Package[] array = new Package[]{};
        return this._packageList.toArray(array);
    }

    public List<Package> getPackageCollection() {
        return this._packageList;
    }

    public int getPackageCount() {
        return this._packageList.size();
    }

    public Integer getThreads() {
        return this.threads;
    }

    public Thresholder getThresholder(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.thresholderList.size()) {
            throw new IndexOutOfBoundsException("getThresholder: Index value '" + index + "' not in range [0.." + (this.thresholderList.size() - 1) + "]");
        }
        return this.thresholderList.get(index);
    }

    public Thresholder[] getThresholder() {
        Thresholder[] array = new Thresholder[]{};
        return this.thresholderList.toArray(array);
    }

    public List<Thresholder> getThresholderCollection() {
        return this.thresholderList;
    }

    public int getThresholderCount() {
        return this.thresholderList.size();
    }

    public boolean hasThreads() {
        return this.threads != null;
    }

    public int hashCode() {
        int hash = Objects.hash(this.threads, this._packageList, this.thresholderList);
        return hash;
    }

    public Iterator<Package> iteratePackage() {
        return this._packageList.iterator();
    }

    public Iterator<Thresholder> iterateThresholder() {
        return this.thresholderList.iterator();
    }

    public void removeAllPackage() {
        this._packageList.clear();
    }

    public void removeAllThresholder() {
        this.thresholderList.clear();
    }

    public boolean removePackage(Package vPackage) {
        boolean removed = this._packageList.remove(vPackage);
        return removed;
    }

    public Package removePackageAt(int index) {
        Package obj = this._packageList.remove(index);
        return obj;
    }

    public boolean removeThresholder(Thresholder vThresholder) {
        boolean removed = this.thresholderList.remove(vThresholder);
        return removed;
    }

    public Thresholder removeThresholderAt(int index) {
        Thresholder obj = this.thresholderList.remove(index);
        return obj;
    }

    public void setPackage(int index, Package vPackage) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._packageList.size()) {
            throw new IndexOutOfBoundsException("setPackage: Index value '" + index + "' not in range [0.." + (this._packageList.size() - 1) + "]");
        }
        this._packageList.set(index, vPackage);
    }

    public void setPackage(Package[] vPackageArray) {
        this._packageList.clear();
        for (int i = 0; i < vPackageArray.length; ++i) {
            this._packageList.add(vPackageArray[i]);
        }
    }

    public void setPackage(List<Package> vPackageList) {
        this._packageList.clear();
        this._packageList.addAll(vPackageList);
    }

    public void setPackageCollection(List<Package> _packageList) {
        this._packageList = _packageList;
    }

    public void setThreads(Integer threads) {
        this.threads = threads;
    }

    public void setThresholder(int index, Thresholder vThresholder) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.thresholderList.size()) {
            throw new IndexOutOfBoundsException("setThresholder: Index value '" + index + "' not in range [0.." + (this.thresholderList.size() - 1) + "]");
        }
        this.thresholderList.set(index, vThresholder);
    }

    public void setThresholder(Thresholder[] vThresholderArray) {
        this.thresholderList.clear();
        for (int i = 0; i < vThresholderArray.length; ++i) {
            this.thresholderList.add(vThresholderArray[i]);
        }
    }

    public void setThresholder(List<Thresholder> vThresholderList) {
        this.thresholderList.clear();
        this.thresholderList.addAll(vThresholderList);
    }

    public void setThresholderCollection(List<Thresholder> thresholderList) {
        this.thresholderList = thresholderList;
    }
}

