/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.syslogd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.config.syslogd.HostaddrMatch;
import org.opennms.netmgt.config.syslogd.HostnameMatch;
import org.opennms.netmgt.config.syslogd.Match;
import org.opennms.netmgt.config.syslogd.ParameterAssignment;
import org.opennms.netmgt.config.syslogd.ProcessMatch;

@XmlRootElement(name="ueiMatch")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class UeiMatch
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="facility")
    private List<String> facilityList = new ArrayList<String>();
    @XmlElement(name="severity")
    private List<String> severityList = new ArrayList<String>();
    @XmlElement(name="process-match")
    private ProcessMatch processMatch;
    @XmlElement(name="hostname-match")
    private HostnameMatch hostnameMatch;
    @XmlElement(name="hostaddr-match")
    private HostaddrMatch hostaddrMatch;
    @XmlElement(name="match", required=true)
    private Match match;
    @XmlElement(name="uei", required=true)
    private String uei;
    @XmlElement(name="parameter-assignment")
    private List<ParameterAssignment> parameterAssignmentList = new ArrayList<ParameterAssignment>();

    public void addFacility(String vFacility) throws IndexOutOfBoundsException {
        this.facilityList.add(vFacility);
    }

    public void addFacility(int index, String vFacility) throws IndexOutOfBoundsException {
        this.facilityList.add(index, vFacility);
    }

    public void addParameterAssignment(ParameterAssignment vParameterAssignment) throws IndexOutOfBoundsException {
        this.parameterAssignmentList.add(vParameterAssignment);
    }

    public void addParameterAssignment(int index, ParameterAssignment vParameterAssignment) throws IndexOutOfBoundsException {
        this.parameterAssignmentList.add(index, vParameterAssignment);
    }

    public void addSeverity(String vSeverity) throws IndexOutOfBoundsException {
        this.severityList.add(vSeverity);
    }

    public void addSeverity(int index, String vSeverity) throws IndexOutOfBoundsException {
        this.severityList.add(index, vSeverity);
    }

    public Enumeration<String> enumerateFacility() {
        return Collections.enumeration(this.facilityList);
    }

    public Enumeration<ParameterAssignment> enumerateParameterAssignment() {
        return Collections.enumeration(this.parameterAssignmentList);
    }

    public Enumeration<String> enumerateSeverity() {
        return Collections.enumeration(this.severityList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof UeiMatch) {
            UeiMatch temp = (UeiMatch)obj;
            boolean equals = Objects.equals(temp.facilityList, this.facilityList) && Objects.equals(temp.severityList, this.severityList) && Objects.equals(temp.processMatch, this.processMatch) && Objects.equals(temp.hostnameMatch, this.hostnameMatch) && Objects.equals(temp.hostaddrMatch, this.hostaddrMatch) && Objects.equals(temp.match, this.match) && Objects.equals(temp.uei, this.uei) && Objects.equals(temp.parameterAssignmentList, this.parameterAssignmentList);
            return equals;
        }
        return false;
    }

    public String getFacility(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.facilityList.size()) {
            throw new IndexOutOfBoundsException("getFacility: Index value '" + index + "' not in range [0.." + (this.facilityList.size() - 1) + "]");
        }
        return this.facilityList.get(index);
    }

    public String[] getFacility() {
        String[] array = new String[]{};
        return this.facilityList.toArray(array);
    }

    public List<String> getFacilityCollection() {
        return this.facilityList;
    }

    public int getFacilityCount() {
        return this.facilityList.size();
    }

    public HostaddrMatch getHostaddrMatch() {
        return this.hostaddrMatch;
    }

    public HostnameMatch getHostnameMatch() {
        return this.hostnameMatch;
    }

    public Match getMatch() {
        return this.match;
    }

    public ParameterAssignment getParameterAssignment(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.parameterAssignmentList.size()) {
            throw new IndexOutOfBoundsException("getParameterAssignment: Index value '" + index + "' not in range [0.." + (this.parameterAssignmentList.size() - 1) + "]");
        }
        return this.parameterAssignmentList.get(index);
    }

    public ParameterAssignment[] getParameterAssignment() {
        ParameterAssignment[] array = new ParameterAssignment[]{};
        return this.parameterAssignmentList.toArray(array);
    }

    public List<ParameterAssignment> getParameterAssignmentCollection() {
        return this.parameterAssignmentList;
    }

    public int getParameterAssignmentCount() {
        return this.parameterAssignmentList.size();
    }

    public ProcessMatch getProcessMatch() {
        return this.processMatch;
    }

    public String getSeverity(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.severityList.size()) {
            throw new IndexOutOfBoundsException("getSeverity: Index value '" + index + "' not in range [0.." + (this.severityList.size() - 1) + "]");
        }
        return this.severityList.get(index);
    }

    public String[] getSeverity() {
        String[] array = new String[]{};
        return this.severityList.toArray(array);
    }

    public List<String> getSeverityCollection() {
        return this.severityList;
    }

    public int getSeverityCount() {
        return this.severityList.size();
    }

    public String getUei() {
        return this.uei;
    }

    public int hashCode() {
        int hash = Objects.hash(this.facilityList, this.severityList, this.processMatch, this.hostnameMatch, this.hostaddrMatch, this.match, this.uei, this.parameterAssignmentList);
        return hash;
    }

    public Iterator<String> iterateFacility() {
        return this.facilityList.iterator();
    }

    public Iterator<ParameterAssignment> iterateParameterAssignment() {
        return this.parameterAssignmentList.iterator();
    }

    public Iterator<String> iterateSeverity() {
        return this.severityList.iterator();
    }

    public void removeAllFacility() {
        this.facilityList.clear();
    }

    public void removeAllParameterAssignment() {
        this.parameterAssignmentList.clear();
    }

    public void removeAllSeverity() {
        this.severityList.clear();
    }

    public boolean removeFacility(String vFacility) {
        boolean removed = this.facilityList.remove(vFacility);
        return removed;
    }

    public String removeFacilityAt(int index) {
        String obj = this.facilityList.remove(index);
        return obj;
    }

    public boolean removeParameterAssignment(ParameterAssignment vParameterAssignment) {
        boolean removed = this.parameterAssignmentList.remove(vParameterAssignment);
        return removed;
    }

    public ParameterAssignment removeParameterAssignmentAt(int index) {
        ParameterAssignment obj = this.parameterAssignmentList.remove(index);
        return obj;
    }

    public boolean removeSeverity(String vSeverity) {
        boolean removed = this.severityList.remove(vSeverity);
        return removed;
    }

    public String removeSeverityAt(int index) {
        String obj = this.severityList.remove(index);
        return obj;
    }

    public void setFacility(int index, String vFacility) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.facilityList.size()) {
            throw new IndexOutOfBoundsException("setFacility: Index value '" + index + "' not in range [0.." + (this.facilityList.size() - 1) + "]");
        }
        this.facilityList.set(index, vFacility);
    }

    public void setFacility(String[] vFacilityArray) {
        this.facilityList.clear();
        for (int i = 0; i < vFacilityArray.length; ++i) {
            this.facilityList.add(vFacilityArray[i]);
        }
    }

    public void setFacility(List<String> vFacilityList) {
        this.facilityList.clear();
        this.facilityList.addAll(vFacilityList);
    }

    public void setFacilityCollection(List<String> facilityList) {
        this.facilityList = facilityList;
    }

    public void setHostaddrMatch(HostaddrMatch hostaddrMatch) {
        this.hostaddrMatch = hostaddrMatch;
    }

    public void setHostnameMatch(HostnameMatch hostnameMatch) {
        this.hostnameMatch = hostnameMatch;
    }

    public void setMatch(Match match) {
        this.match = match;
    }

    public void setParameterAssignment(int index, ParameterAssignment vParameterAssignment) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.parameterAssignmentList.size()) {
            throw new IndexOutOfBoundsException("setParameterAssignment: Index value '" + index + "' not in range [0.." + (this.parameterAssignmentList.size() - 1) + "]");
        }
        this.parameterAssignmentList.set(index, vParameterAssignment);
    }

    public void setParameterAssignment(ParameterAssignment[] vParameterAssignmentArray) {
        this.parameterAssignmentList.clear();
        for (int i = 0; i < vParameterAssignmentArray.length; ++i) {
            this.parameterAssignmentList.add(vParameterAssignmentArray[i]);
        }
    }

    public void setParameterAssignment(List<ParameterAssignment> vParameterAssignmentList) {
        this.parameterAssignmentList.clear();
        this.parameterAssignmentList.addAll(vParameterAssignmentList);
    }

    public void setParameterAssignmentCollection(List<ParameterAssignment> parameterAssignmentList) {
        this.parameterAssignmentList = parameterAssignmentList;
    }

    public void setProcessMatch(ProcessMatch processMatch) {
        this.processMatch = processMatch;
    }

    public void setSeverity(int index, String vSeverity) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.severityList.size()) {
            throw new IndexOutOfBoundsException("setSeverity: Index value '" + index + "' not in range [0.." + (this.severityList.size() - 1) + "]");
        }
        this.severityList.set(index, vSeverity);
    }

    public void setSeverity(String[] vSeverityArray) {
        this.severityList.clear();
        for (int i = 0; i < vSeverityArray.length; ++i) {
            this.severityList.add(vSeverityArray[i]);
        }
    }

    public void setSeverity(List<String> vSeverityList) {
        this.severityList.clear();
        this.severityList.addAll(vSeverityList);
    }

    public void setSeverityCollection(List<String> severityList) {
        this.severityList = severityList;
    }

    public void setUei(String uei) {
        this.uei = uei;
    }
}

