/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.surveillanceViews;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.config.surveillanceViews.View;

@XmlRootElement(name="views")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Views
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="view")
    private List<View> viewList = new ArrayList<View>();

    public void addView(View vView) throws IndexOutOfBoundsException {
        this.viewList.add(vView);
    }

    public void addView(int index, View vView) throws IndexOutOfBoundsException {
        this.viewList.add(index, vView);
    }

    public Enumeration<View> enumerateView() {
        return Collections.enumeration(this.viewList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Views) {
            Views temp = (Views)obj;
            boolean equals = Objects.equals(temp.viewList, this.viewList);
            return equals;
        }
        return false;
    }

    public View getView(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.viewList.size()) {
            throw new IndexOutOfBoundsException("getView: Index value '" + index + "' not in range [0.." + (this.viewList.size() - 1) + "]");
        }
        return this.viewList.get(index);
    }

    public View[] getView() {
        View[] array = new View[]{};
        return this.viewList.toArray(array);
    }

    public List<View> getViewCollection() {
        return this.viewList;
    }

    public int getViewCount() {
        return this.viewList.size();
    }

    public int hashCode() {
        int hash = Objects.hash(this.viewList);
        return hash;
    }

    public Iterator<View> iterateView() {
        return this.viewList.iterator();
    }

    public void removeAllView() {
        this.viewList.clear();
    }

    public boolean removeView(View vView) {
        boolean removed = this.viewList.remove(vView);
        return removed;
    }

    public View removeViewAt(int index) {
        View obj = this.viewList.remove(index);
        return obj;
    }

    public void setView(int index, View vView) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.viewList.size()) {
            throw new IndexOutOfBoundsException("setView: Index value '" + index + "' not in range [0.." + (this.viewList.size() - 1) + "]");
        }
        this.viewList.set(index, vView);
    }

    public void setView(View[] vViewArray) {
        this.viewList.clear();
        for (int i = 0; i < vViewArray.length; ++i) {
            this.viewList.add(vViewArray[i]);
        }
    }

    public void setView(List<View> vViewList) {
        this.viewList.clear();
        this.viewList.addAll(vViewList);
    }

    public void setViewCollection(List<View> viewList) {
        this.viewList = viewList;
    }
}

