/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.statsd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.config.statsd.Package;
import org.opennms.netmgt.config.statsd.Report;

@XmlRootElement(name="statistics-daemon-configuration")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class StatisticsDaemonConfiguration
implements Serializable {
    @XmlElement(name="package", required=true)
    private List<Package> _packageList = new ArrayList<Package>();
    @XmlElement(name="report", required=true)
    private List<Report> reportList = new ArrayList<Report>();

    public void addPackage(Package vPackage) throws IndexOutOfBoundsException {
        this._packageList.add(vPackage);
    }

    public void addPackage(int index, Package vPackage) throws IndexOutOfBoundsException {
        this._packageList.add(index, vPackage);
    }

    public void addReport(Report vReport) throws IndexOutOfBoundsException {
        this.reportList.add(vReport);
    }

    public void addReport(int index, Report vReport) throws IndexOutOfBoundsException {
        this.reportList.add(index, vReport);
    }

    public Enumeration<Package> enumeratePackage() {
        return Collections.enumeration(this._packageList);
    }

    public Enumeration<Report> enumerateReport() {
        return Collections.enumeration(this.reportList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof StatisticsDaemonConfiguration) {
            StatisticsDaemonConfiguration temp = (StatisticsDaemonConfiguration)obj;
            boolean equals = Objects.equals(temp._packageList, this._packageList) && Objects.equals(temp.reportList, this.reportList);
            return equals;
        }
        return false;
    }

    public Package getPackage(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._packageList.size()) {
            throw new IndexOutOfBoundsException("getPackage: Index value '" + index + "' not in range [0.." + (this._packageList.size() - 1) + "]");
        }
        return this._packageList.get(index);
    }

    public Package[] getPackage() {
        Package[] array = new Package[]{};
        return this._packageList.toArray(array);
    }

    public List<Package> getPackageCollection() {
        return this._packageList;
    }

    public int getPackageCount() {
        return this._packageList.size();
    }

    public Report getReport(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.reportList.size()) {
            throw new IndexOutOfBoundsException("getReport: Index value '" + index + "' not in range [0.." + (this.reportList.size() - 1) + "]");
        }
        return this.reportList.get(index);
    }

    public Report[] getReport() {
        Report[] array = new Report[]{};
        return this.reportList.toArray(array);
    }

    public List<Report> getReportCollection() {
        return this.reportList;
    }

    public int getReportCount() {
        return this.reportList.size();
    }

    public int hashCode() {
        int hash = Objects.hash(this._packageList, this.reportList);
        return hash;
    }

    public Iterator<Package> iteratePackage() {
        return this._packageList.iterator();
    }

    public Iterator<Report> iterateReport() {
        return this.reportList.iterator();
    }

    public void removeAllPackage() {
        this._packageList.clear();
    }

    public void removeAllReport() {
        this.reportList.clear();
    }

    public boolean removePackage(Package vPackage) {
        boolean removed = this._packageList.remove(vPackage);
        return removed;
    }

    public Package removePackageAt(int index) {
        Package obj = this._packageList.remove(index);
        return obj;
    }

    public boolean removeReport(Report vReport) {
        boolean removed = this.reportList.remove(vReport);
        return removed;
    }

    public Report removeReportAt(int index) {
        Report obj = this.reportList.remove(index);
        return obj;
    }

    public void setPackage(int index, Package vPackage) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._packageList.size()) {
            throw new IndexOutOfBoundsException("setPackage: Index value '" + index + "' not in range [0.." + (this._packageList.size() - 1) + "]");
        }
        this._packageList.set(index, vPackage);
    }

    public void setPackage(Package[] vPackageArray) {
        this._packageList.clear();
        for (int i = 0; i < vPackageArray.length; ++i) {
            this._packageList.add(vPackageArray[i]);
        }
    }

    public void setPackage(List<Package> vPackageList) {
        this._packageList.clear();
        this._packageList.addAll(vPackageList);
    }

    public void setPackageCollection(List<Package> _packageList) {
        this._packageList = _packageList;
    }

    public void setReport(int index, Report vReport) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.reportList.size()) {
            throw new IndexOutOfBoundsException("setReport: Index value '" + index + "' not in range [0.." + (this.reportList.size() - 1) + "]");
        }
        this.reportList.set(index, vReport);
    }

    public void setReport(Report[] vReportArray) {
        this.reportList.clear();
        for (int i = 0; i < vReportArray.length; ++i) {
            this.reportList.add(vReportArray[i]);
        }
    }

    public void setReport(List<Report> vReportList) {
        this.reportList.clear();
        this.reportList.addAll(vReportList);
    }

    public void setReportCollection(List<Report> reportList) {
        this.reportList = reportList;
    }
}

