/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.snmpinterfacepoller;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.config.snmpinterfacepoller.NodeOutage;
import org.opennms.netmgt.config.snmpinterfacepoller.Package;

@XmlRootElement(name="snmp-interface-poller-configuration")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SnmpInterfacePollerConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_SUPPRESS_ADMIN_DOWN_EVENT = "true";
    private static final String DEFAULT_USE_CRITERIA_FILTERS = "false";
    @XmlAttribute(name="interval")
    private Long interval;
    @XmlAttribute(name="threads", required=true)
    private Integer threads;
    @XmlAttribute(name="service", required=true)
    private String service;
    @XmlAttribute(name="suppressAdminDownEvent")
    private String suppressAdminDownEvent;
    @XmlAttribute(name="useCriteriaFilters")
    private String useCriteriaFilters;
    @XmlElement(name="node-outage", required=true)
    private NodeOutage nodeOutage;
    @XmlElement(name="package", required=true)
    private List<Package> _packageList = new ArrayList<Package>();

    public void addPackage(Package vPackage) throws IndexOutOfBoundsException {
        this._packageList.add(vPackage);
    }

    public void addPackage(int index, Package vPackage) throws IndexOutOfBoundsException {
        this._packageList.add(index, vPackage);
    }

    public void deleteInterval() {
        this.interval = null;
    }

    public void deleteThreads() {
        this.threads = null;
    }

    public Enumeration<Package> enumeratePackage() {
        return Collections.enumeration(this._packageList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SnmpInterfacePollerConfiguration) {
            SnmpInterfacePollerConfiguration temp = (SnmpInterfacePollerConfiguration)obj;
            boolean equals = Objects.equals(temp.interval, this.interval) && Objects.equals(temp.threads, this.threads) && Objects.equals(temp.service, this.service) && Objects.equals(temp.suppressAdminDownEvent, this.suppressAdminDownEvent) && Objects.equals(temp.useCriteriaFilters, this.useCriteriaFilters) && Objects.equals(temp.nodeOutage, this.nodeOutage) && Objects.equals(temp._packageList, this._packageList);
            return equals;
        }
        return false;
    }

    public Long getInterval() {
        return this.interval != null ? this.interval : Long.valueOf("300000");
    }

    public NodeOutage getNodeOutage() {
        return this.nodeOutage;
    }

    public Package getPackage(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._packageList.size()) {
            throw new IndexOutOfBoundsException("getPackage: Index value '" + index + "' not in range [0.." + (this._packageList.size() - 1) + "]");
        }
        return this._packageList.get(index);
    }

    public Package[] getPackage() {
        Package[] array = new Package[]{};
        return this._packageList.toArray(array);
    }

    public List<Package> getPackageCollection() {
        return this._packageList;
    }

    public int getPackageCount() {
        return this._packageList.size();
    }

    public String getService() {
        return this.service;
    }

    public String getSuppressAdminDownEvent() {
        return this.suppressAdminDownEvent != null ? this.suppressAdminDownEvent : DEFAULT_SUPPRESS_ADMIN_DOWN_EVENT;
    }

    public Integer getThreads() {
        return this.threads;
    }

    public String getUseCriteriaFilters() {
        return this.useCriteriaFilters != null ? this.useCriteriaFilters : DEFAULT_USE_CRITERIA_FILTERS;
    }

    public boolean hasInterval() {
        return this.interval != null;
    }

    public boolean hasThreads() {
        return this.threads != null;
    }

    public int hashCode() {
        int hash = Objects.hash(this.interval, this.threads, this.service, this.suppressAdminDownEvent, this.useCriteriaFilters, this.nodeOutage, this._packageList);
        return hash;
    }

    public Iterator<Package> iteratePackage() {
        return this._packageList.iterator();
    }

    public void removeAllPackage() {
        this._packageList.clear();
    }

    public boolean removePackage(Package vPackage) {
        boolean removed = this._packageList.remove(vPackage);
        return removed;
    }

    public Package removePackageAt(int index) {
        Package obj = this._packageList.remove(index);
        return obj;
    }

    public void setInterval(Long interval) {
        this.interval = interval;
    }

    public void setNodeOutage(NodeOutage nodeOutage) {
        this.nodeOutage = nodeOutage;
    }

    public void setPackage(int index, Package vPackage) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._packageList.size()) {
            throw new IndexOutOfBoundsException("setPackage: Index value '" + index + "' not in range [0.." + (this._packageList.size() - 1) + "]");
        }
        this._packageList.set(index, vPackage);
    }

    public void setPackage(Package[] vPackageArray) {
        this._packageList.clear();
        for (int i = 0; i < vPackageArray.length; ++i) {
            this._packageList.add(vPackageArray[i]);
        }
    }

    public void setPackage(List<Package> vPackageList) {
        this._packageList.clear();
        this._packageList.addAll(vPackageList);
    }

    public void setPackageCollection(List<Package> _packageList) {
        this._packageList = _packageList;
    }

    public void setService(String service) {
        this.service = service;
    }

    public void setSuppressAdminDownEvent(String suppressAdminDownEvent) {
        this.suppressAdminDownEvent = suppressAdminDownEvent;
    }

    public void setThreads(Integer threads) {
        this.threads = threads;
    }

    public void setUseCriteriaFilters(String useCriteriaFilters) {
        this.useCriteriaFilters = useCriteriaFilters;
    }
}

