/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.provisiond;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.config.provisiond.RequisitionDef;

@XmlRootElement(name="provisiond-configuration")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ProvisiondConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_REQUISITION_DIR = "${install.dir}/etc/imports";
    private static final String DEFAULT_FOREIGN_SOURCE_DIR = "${install.dir}/etc/foreign-sources";
    @XmlAttribute(name="importThreads")
    private Long importThreads;
    @XmlAttribute(name="scanThreads")
    private Long scanThreads;
    @XmlAttribute(name="rescanThreads")
    private Long rescanThreads;
    @XmlAttribute(name="writeThreads")
    private Long writeThreads;
    @XmlAttribute(name="requistion-dir")
    private String requistionDir;
    @XmlAttribute(name="foreign-source-dir")
    private String foreignSourceDir;
    @XmlElement(name="requisition-def")
    private List<RequisitionDef> requisitionDefList = new ArrayList<RequisitionDef>();

    public void addRequisitionDef(RequisitionDef vRequisitionDef) throws IndexOutOfBoundsException {
        this.requisitionDefList.add(vRequisitionDef);
    }

    public void addRequisitionDef(int index, RequisitionDef vRequisitionDef) throws IndexOutOfBoundsException {
        this.requisitionDefList.add(index, vRequisitionDef);
    }

    public void deleteImportThreads() {
        this.importThreads = null;
    }

    public void deleteRescanThreads() {
        this.rescanThreads = null;
    }

    public void deleteScanThreads() {
        this.scanThreads = null;
    }

    public void deleteWriteThreads() {
        this.writeThreads = null;
    }

    public Enumeration<RequisitionDef> enumerateRequisitionDef() {
        return Collections.enumeration(this.requisitionDefList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ProvisiondConfiguration) {
            ProvisiondConfiguration temp = (ProvisiondConfiguration)obj;
            boolean equals = Objects.equals(temp.importThreads, this.importThreads) && Objects.equals(temp.scanThreads, this.scanThreads) && Objects.equals(temp.rescanThreads, this.rescanThreads) && Objects.equals(temp.writeThreads, this.writeThreads) && Objects.equals(temp.requistionDir, this.requistionDir) && Objects.equals(temp.foreignSourceDir, this.foreignSourceDir) && Objects.equals(temp.requisitionDefList, this.requisitionDefList);
            return equals;
        }
        return false;
    }

    public String getForeignSourceDir() {
        return this.foreignSourceDir != null ? this.foreignSourceDir : DEFAULT_FOREIGN_SOURCE_DIR;
    }

    public Long getImportThreads() {
        return this.importThreads != null ? this.importThreads : Long.valueOf("8");
    }

    public RequisitionDef getRequisitionDef(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.requisitionDefList.size()) {
            throw new IndexOutOfBoundsException("getRequisitionDef: Index value '" + index + "' not in range [0.." + (this.requisitionDefList.size() - 1) + "]");
        }
        return this.requisitionDefList.get(index);
    }

    public RequisitionDef[] getRequisitionDef() {
        RequisitionDef[] array = new RequisitionDef[]{};
        return this.requisitionDefList.toArray(array);
    }

    public List<RequisitionDef> getRequisitionDefCollection() {
        return this.requisitionDefList;
    }

    public int getRequisitionDefCount() {
        return this.requisitionDefList.size();
    }

    public String getRequistionDir() {
        return this.requistionDir != null ? this.requistionDir : DEFAULT_REQUISITION_DIR;
    }

    public Long getRescanThreads() {
        return this.rescanThreads != null ? this.rescanThreads : Long.valueOf("10");
    }

    public Long getScanThreads() {
        return this.scanThreads != null ? this.scanThreads : Long.valueOf("10");
    }

    public Long getWriteThreads() {
        return this.writeThreads != null ? this.writeThreads : Long.valueOf("8");
    }

    public boolean hasImportThreads() {
        return this.importThreads != null;
    }

    public boolean hasRescanThreads() {
        return this.rescanThreads != null;
    }

    public boolean hasScanThreads() {
        return this.scanThreads != null;
    }

    public boolean hasWriteThreads() {
        return this.writeThreads != null;
    }

    public int hashCode() {
        int hash = Objects.hash(this.importThreads, this.scanThreads, this.rescanThreads, this.writeThreads, this.requistionDir, this.foreignSourceDir, this.requisitionDefList);
        return hash;
    }

    public Iterator<RequisitionDef> iterateRequisitionDef() {
        return this.requisitionDefList.iterator();
    }

    public void removeAllRequisitionDef() {
        this.requisitionDefList.clear();
    }

    public boolean removeRequisitionDef(RequisitionDef vRequisitionDef) {
        boolean removed = this.requisitionDefList.remove(vRequisitionDef);
        return removed;
    }

    public RequisitionDef removeRequisitionDefAt(int index) {
        RequisitionDef obj = this.requisitionDefList.remove(index);
        return obj;
    }

    public void setForeignSourceDir(String foreignSourceDir) {
        this.foreignSourceDir = foreignSourceDir;
    }

    public void setImportThreads(Long importThreads) {
        this.importThreads = importThreads;
    }

    public void setRequisitionDef(int index, RequisitionDef vRequisitionDef) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.requisitionDefList.size()) {
            throw new IndexOutOfBoundsException("setRequisitionDef: Index value '" + index + "' not in range [0.." + (this.requisitionDefList.size() - 1) + "]");
        }
        this.requisitionDefList.set(index, vRequisitionDef);
    }

    public void setRequisitionDef(RequisitionDef[] vRequisitionDefArray) {
        this.requisitionDefList.clear();
        for (int i = 0; i < vRequisitionDefArray.length; ++i) {
            this.requisitionDefList.add(vRequisitionDefArray[i]);
        }
    }

    public void setRequisitionDef(List<RequisitionDef> vRequisitionDefList) {
        this.requisitionDefList.clear();
        this.requisitionDefList.addAll(vRequisitionDefList);
    }

    public void setRequisitionDefCollection(List<RequisitionDef> requisitionDefList) {
        this.requisitionDefList = requisitionDefList;
    }

    public void setRequistionDir(String requistionDir) {
        this.requistionDir = requistionDir;
    }

    public void setRescanThreads(Long rescanThreads) {
        this.rescanThreads = rescanThreads;
    }

    public void setScanThreads(Long scanThreads) {
        this.scanThreads = scanThreads;
    }

    public void setWriteThreads(Long writeThreads) {
        this.writeThreads = writeThreads;
    }
}

