/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.notifications;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.config.notifications.Parameter;
import org.opennms.netmgt.config.notifications.Varbind;

@XmlRootElement(name="notification")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Notification
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_WRITEABLE = "yes";
    @XmlAttribute(name="name", required=true)
    private String name;
    @XmlAttribute(name="status", required=true)
    private String status;
    @XmlAttribute(name="writeable")
    private String writeable;
    @XmlElement(name="uei", required=true)
    private String uei;
    @XmlElement(name="description")
    private String description;
    @XmlElement(name="rule", required=true)
    private String rule;
    @XmlElement(name="notice-queue")
    private String noticeQueue;
    @XmlElement(name="destinationPath", required=true)
    private String destinationPath;
    @XmlElement(name="text-message", required=true)
    private String textMessage;
    @XmlElement(name="subject")
    private String subject;
    @XmlElement(name="numeric-message")
    private String numericMessage;
    @XmlElement(name="event-severity")
    private String eventSeverity;
    @XmlElement(name="parameter")
    private List<Parameter> parameterList = new ArrayList<Parameter>();
    @XmlElement(name="varbind")
    private Varbind varbind;

    public void addParameter(Parameter vParameter) throws IndexOutOfBoundsException {
        this.parameterList.add(vParameter);
    }

    public void addParameter(int index, Parameter vParameter) throws IndexOutOfBoundsException {
        this.parameterList.add(index, vParameter);
    }

    public Enumeration<Parameter> enumerateParameter() {
        return Collections.enumeration(this.parameterList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Notification) {
            Notification temp = (Notification)obj;
            boolean equals = Objects.equals(temp.name, this.name) && Objects.equals(temp.status, this.status) && Objects.equals(temp.writeable, this.writeable) && Objects.equals(temp.uei, this.uei) && Objects.equals(temp.description, this.description) && Objects.equals(temp.rule, this.rule) && Objects.equals(temp.noticeQueue, this.noticeQueue) && Objects.equals(temp.destinationPath, this.destinationPath) && Objects.equals(temp.textMessage, this.textMessage) && Objects.equals(temp.subject, this.subject) && Objects.equals(temp.numericMessage, this.numericMessage) && Objects.equals(temp.eventSeverity, this.eventSeverity) && Objects.equals(temp.parameterList, this.parameterList) && Objects.equals(temp.varbind, this.varbind);
            return equals;
        }
        return false;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDestinationPath() {
        return this.destinationPath;
    }

    public String getEventSeverity() {
        return this.eventSeverity;
    }

    public String getName() {
        return this.name;
    }

    public String getNoticeQueue() {
        return this.noticeQueue;
    }

    public String getNumericMessage() {
        return this.numericMessage;
    }

    public Parameter getParameter(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.parameterList.size()) {
            throw new IndexOutOfBoundsException("getParameter: Index value '" + index + "' not in range [0.." + (this.parameterList.size() - 1) + "]");
        }
        return this.parameterList.get(index);
    }

    public Parameter[] getParameter() {
        Parameter[] array = new Parameter[]{};
        return this.parameterList.toArray(array);
    }

    public List<Parameter> getParameterCollection() {
        return this.parameterList;
    }

    public int getParameterCount() {
        return this.parameterList.size();
    }

    public String getRule() {
        return this.rule;
    }

    public String getStatus() {
        return this.status;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getTextMessage() {
        return this.textMessage;
    }

    public String getUei() {
        return this.uei;
    }

    public Varbind getVarbind() {
        return this.varbind;
    }

    public String getWriteable() {
        return this.writeable != null ? this.writeable : DEFAULT_WRITEABLE;
    }

    public int hashCode() {
        int hash = Objects.hash(this.name, this.status, this.writeable, this.uei, this.description, this.rule, this.noticeQueue, this.destinationPath, this.textMessage, this.subject, this.numericMessage, this.eventSeverity, this.parameterList, this.varbind);
        return hash;
    }

    public Iterator<Parameter> iterateParameter() {
        return this.parameterList.iterator();
    }

    public void removeAllParameter() {
        this.parameterList.clear();
    }

    public boolean removeParameter(Parameter vParameter) {
        boolean removed = this.parameterList.remove(vParameter);
        return removed;
    }

    public Parameter removeParameterAt(int index) {
        Parameter obj = this.parameterList.remove(index);
        return obj;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDestinationPath(String destinationPath) {
        this.destinationPath = destinationPath;
    }

    public void setEventSeverity(String eventSeverity) {
        this.eventSeverity = eventSeverity;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNoticeQueue(String noticeQueue) {
        this.noticeQueue = noticeQueue;
    }

    public void setNumericMessage(String numericMessage) {
        this.numericMessage = numericMessage;
    }

    public void setParameter(int index, Parameter vParameter) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.parameterList.size()) {
            throw new IndexOutOfBoundsException("setParameter: Index value '" + index + "' not in range [0.." + (this.parameterList.size() - 1) + "]");
        }
        this.parameterList.set(index, vParameter);
    }

    public void setParameter(Parameter[] vParameterArray) {
        this.parameterList.clear();
        for (int i = 0; i < vParameterArray.length; ++i) {
            this.parameterList.add(vParameterArray[i]);
        }
    }

    public void setParameter(List<Parameter> vParameterList) {
        this.parameterList.clear();
        this.parameterList.addAll(vParameterList);
    }

    public void setParameterCollection(List<Parameter> parameterList) {
        this.parameterList = parameterList;
    }

    public void setRule(String rule) {
        this.rule = rule;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setTextMessage(String textMessage) {
        this.textMessage = textMessage;
    }

    public void setUei(String uei) {
        this.uei = uei;
    }

    public void setVarbind(Varbind varbind) {
        this.varbind = varbind;
    }

    public void setWriteable(String writeable) {
        this.writeable = writeable;
    }
}

