/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.notificationCommands;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.config.notificationCommands.Argument;

@XmlRootElement(name="command")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Command
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_BINARY = "true";
    @XmlAttribute(name="binary")
    private String binary;
    @XmlElement(name="name", required=true)
    private String name;
    @XmlElement(name="execute", required=true)
    private String execute;
    @XmlElement(name="comment")
    private String comment;
    @XmlElement(name="contact-type")
    private String contactType;
    @XmlElement(name="argument")
    private List<Argument> argumentList = new ArrayList<Argument>();

    public void addArgument(Argument vArgument) throws IndexOutOfBoundsException {
        this.argumentList.add(vArgument);
    }

    public void addArgument(int index, Argument vArgument) throws IndexOutOfBoundsException {
        this.argumentList.add(index, vArgument);
    }

    public Enumeration<Argument> enumerateArgument() {
        return Collections.enumeration(this.argumentList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Command) {
            Command temp = (Command)obj;
            boolean equals = Objects.equals(temp.binary, this.binary) && Objects.equals(temp.name, this.name) && Objects.equals(temp.execute, this.execute) && Objects.equals(temp.comment, this.comment) && Objects.equals(temp.contactType, this.contactType) && Objects.equals(temp.argumentList, this.argumentList);
            return equals;
        }
        return false;
    }

    public Argument getArgument(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.argumentList.size()) {
            throw new IndexOutOfBoundsException("getArgument: Index value '" + index + "' not in range [0.." + (this.argumentList.size() - 1) + "]");
        }
        return this.argumentList.get(index);
    }

    public Argument[] getArgument() {
        Argument[] array = new Argument[]{};
        return this.argumentList.toArray(array);
    }

    public List<Argument> getArgumentCollection() {
        return this.argumentList;
    }

    public int getArgumentCount() {
        return this.argumentList.size();
    }

    public String getBinary() {
        return this.binary != null ? this.binary : DEFAULT_BINARY;
    }

    public String getComment() {
        return this.comment;
    }

    public String getContactType() {
        return this.contactType;
    }

    public String getExecute() {
        return this.execute;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        int hash = Objects.hash(this.binary, this.name, this.execute, this.comment, this.contactType, this.argumentList);
        return hash;
    }

    public Iterator<Argument> iterateArgument() {
        return this.argumentList.iterator();
    }

    public void removeAllArgument() {
        this.argumentList.clear();
    }

    public boolean removeArgument(Argument vArgument) {
        boolean removed = this.argumentList.remove(vArgument);
        return removed;
    }

    public Argument removeArgumentAt(int index) {
        Argument obj = this.argumentList.remove(index);
        return obj;
    }

    public void setArgument(int index, Argument vArgument) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.argumentList.size()) {
            throw new IndexOutOfBoundsException("setArgument: Index value '" + index + "' not in range [0.." + (this.argumentList.size() - 1) + "]");
        }
        this.argumentList.set(index, vArgument);
    }

    public void setArgument(Argument[] vArgumentArray) {
        this.argumentList.clear();
        for (int i = 0; i < vArgumentArray.length; ++i) {
            this.argumentList.add(vArgumentArray[i]);
        }
    }

    public void setArgument(List<Argument> vArgumentList) {
        this.argumentList.clear();
        this.argumentList.addAll(vArgumentList);
    }

    public void setArgumentCollection(List<Argument> argumentList) {
        this.argumentList = argumentList;
    }

    public void setBinary(String binary) {
        this.binary = binary;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setContactType(String contactType) {
        this.contactType = contactType;
    }

    public void setExecute(String execute) {
        this.execute = execute;
    }

    public void setName(String name) {
        this.name = name;
    }
}

