/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.notifd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.config.notifd.AutoAcknowledge;
import org.opennms.netmgt.config.notifd.AutoAcknowledgeAlarm;
import org.opennms.netmgt.config.notifd.Queue;

@XmlRootElement(name="notifd-configuration")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class NotifdConfiguration
implements Serializable {
    private static final String DEFAULT_PAGES_SENT = "SELECT * FROM notifications";
    private static final String DEFAULT_NEXT_NOTIFID = "SELECT nextval('notifynxtid')";
    private static final String DEFAULT_NEXT_USER_NOTIFID = "SELECT nextval('userNotifNxtId')";
    private static final String DEFAULT_NEXT_GROUP_ID = "SELECT nextval('notifygrpid')";
    private static final String DEFAULT_SERVICEID_SQL = "SELECT serviceID from service where serviceName = ?";
    private static final String DEFAULT_OUTSTANDING_NOTICES_SQL = "SELECT notifyid FROM notifications where notifyId = ? AND respondTime is not null";
    private static final String DEFAULT_ACKNOWLEDGEID_SQL = "SELECT notifyid FROM notifications WHERE eventuei=? AND nodeid=? AND interfaceid=? AND serviceid=?";
    private static final String DEFAULT_ACKNOWLEDGE_UPDATE_SQL = "UPDATE notifications SET answeredby=?, respondtime=? WHERE notifyId=?";
    private static final String DEFAULT_EMAIL_ADDRESS_COMMAND = "javaEmail";
    @XmlAttribute(name="status", required=true)
    private String status;
    @XmlAttribute(name="pages-sent")
    private String pagesSent;
    @XmlAttribute(name="next-notif-id")
    private String nextNotifId;
    @XmlAttribute(name="next-user-notif-id")
    private String nextUserNotifId;
    @XmlAttribute(name="next-group-id")
    private String nextGroupId;
    @XmlAttribute(name="service-id-sql")
    private String serviceIdSql;
    @XmlAttribute(name="outstanding-notices-sql")
    private String outstandingNoticesSql;
    @XmlAttribute(name="acknowledge-id-sql")
    private String acknowledgeIdSql;
    @XmlAttribute(name="acknowledge-update-sql")
    private String acknowledgeUpdateSql;
    @XmlAttribute(name="match-all", required=true)
    private Boolean matchAll;
    @XmlAttribute(name="email-address-command")
    private String emailAddressCommand;
    @XmlAttribute(name="numeric-skip-resolution-prefix")
    private Boolean numericSkipResolutionPrefix;
    @XmlElement(name="auto-acknowledge-alarm")
    private AutoAcknowledgeAlarm autoAcknowledgeAlarm;
    @XmlElement(name="auto-acknowledge")
    private List<AutoAcknowledge> autoAcknowledgeList = new ArrayList<AutoAcknowledge>();
    @XmlElement(name="queue", required=true)
    private List<Queue> queueList = new ArrayList<Queue>();
    @XmlElement(name="outage-calendar")
    private List<String> outageCalendarList = new ArrayList<String>();

    public void addAutoAcknowledge(AutoAcknowledge vAutoAcknowledge) throws IndexOutOfBoundsException {
        this.autoAcknowledgeList.add(vAutoAcknowledge);
    }

    public void addAutoAcknowledge(int index, AutoAcknowledge vAutoAcknowledge) throws IndexOutOfBoundsException {
        this.autoAcknowledgeList.add(index, vAutoAcknowledge);
    }

    public void addOutageCalendar(String vOutageCalendar) throws IndexOutOfBoundsException {
        this.outageCalendarList.add(vOutageCalendar);
    }

    public void addOutageCalendar(int index, String vOutageCalendar) throws IndexOutOfBoundsException {
        this.outageCalendarList.add(index, vOutageCalendar);
    }

    public void addQueue(Queue vQueue) throws IndexOutOfBoundsException {
        this.queueList.add(vQueue);
    }

    public void addQueue(int index, Queue vQueue) throws IndexOutOfBoundsException {
        this.queueList.add(index, vQueue);
    }

    public void deleteMatchAll() {
        this.matchAll = null;
    }

    public void deleteNumericSkipResolutionPrefix() {
        this.numericSkipResolutionPrefix = null;
    }

    public Enumeration<AutoAcknowledge> enumerateAutoAcknowledge() {
        return Collections.enumeration(this.autoAcknowledgeList);
    }

    public Enumeration<String> enumerateOutageCalendar() {
        return Collections.enumeration(this.outageCalendarList);
    }

    public Enumeration<Queue> enumerateQueue() {
        return Collections.enumeration(this.queueList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof NotifdConfiguration) {
            NotifdConfiguration temp = (NotifdConfiguration)obj;
            boolean equals = Objects.equals(temp.status, this.status) && Objects.equals(temp.pagesSent, this.pagesSent) && Objects.equals(temp.nextNotifId, this.nextNotifId) && Objects.equals(temp.nextUserNotifId, this.nextUserNotifId) && Objects.equals(temp.nextGroupId, this.nextGroupId) && Objects.equals(temp.serviceIdSql, this.serviceIdSql) && Objects.equals(temp.outstandingNoticesSql, this.outstandingNoticesSql) && Objects.equals(temp.acknowledgeIdSql, this.acknowledgeIdSql) && Objects.equals(temp.acknowledgeUpdateSql, this.acknowledgeUpdateSql) && Objects.equals(temp.matchAll, this.matchAll) && Objects.equals(temp.emailAddressCommand, this.emailAddressCommand) && Objects.equals(temp.numericSkipResolutionPrefix, this.numericSkipResolutionPrefix) && Objects.equals(temp.autoAcknowledgeAlarm, this.autoAcknowledgeAlarm) && Objects.equals(temp.autoAcknowledgeList, this.autoAcknowledgeList) && Objects.equals(temp.queueList, this.queueList) && Objects.equals(temp.outageCalendarList, this.outageCalendarList);
            return equals;
        }
        return false;
    }

    public String getAcknowledgeIdSql() {
        return this.acknowledgeIdSql != null ? this.acknowledgeIdSql : DEFAULT_ACKNOWLEDGEID_SQL;
    }

    public String getAcknowledgeUpdateSql() {
        return this.acknowledgeUpdateSql != null ? this.acknowledgeUpdateSql : DEFAULT_ACKNOWLEDGE_UPDATE_SQL;
    }

    public AutoAcknowledge getAutoAcknowledge(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.autoAcknowledgeList.size()) {
            throw new IndexOutOfBoundsException("getAutoAcknowledge: Index value '" + index + "' not in range [0.." + (this.autoAcknowledgeList.size() - 1) + "]");
        }
        return this.autoAcknowledgeList.get(index);
    }

    public AutoAcknowledge[] getAutoAcknowledge() {
        AutoAcknowledge[] array = new AutoAcknowledge[]{};
        return this.autoAcknowledgeList.toArray(array);
    }

    public AutoAcknowledgeAlarm getAutoAcknowledgeAlarm() {
        return this.autoAcknowledgeAlarm;
    }

    public List<AutoAcknowledge> getAutoAcknowledgeCollection() {
        return this.autoAcknowledgeList;
    }

    public int getAutoAcknowledgeCount() {
        return this.autoAcknowledgeList.size();
    }

    public String getEmailAddressCommand() {
        return this.emailAddressCommand != null ? this.emailAddressCommand : DEFAULT_EMAIL_ADDRESS_COMMAND;
    }

    public Boolean getMatchAll() {
        return this.matchAll;
    }

    public String getNextGroupId() {
        return this.nextGroupId != null ? this.nextGroupId : DEFAULT_NEXT_GROUP_ID;
    }

    public String getNextNotifId() {
        return this.nextNotifId != null ? this.nextNotifId : DEFAULT_NEXT_NOTIFID;
    }

    public String getNextUserNotifId() {
        return this.nextUserNotifId != null ? this.nextUserNotifId : DEFAULT_NEXT_USER_NOTIFID;
    }

    public Boolean getNumericSkipResolutionPrefix() {
        return this.numericSkipResolutionPrefix != null ? this.numericSkipResolutionPrefix : Boolean.valueOf("false");
    }

    public String getOutageCalendar(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.outageCalendarList.size()) {
            throw new IndexOutOfBoundsException("getOutageCalendar: Index value '" + index + "' not in range [0.." + (this.outageCalendarList.size() - 1) + "]");
        }
        return this.outageCalendarList.get(index);
    }

    public String[] getOutageCalendar() {
        String[] array = new String[]{};
        return this.outageCalendarList.toArray(array);
    }

    public List<String> getOutageCalendarCollection() {
        return this.outageCalendarList;
    }

    public int getOutageCalendarCount() {
        return this.outageCalendarList.size();
    }

    public String getOutstandingNoticesSql() {
        return this.outstandingNoticesSql != null ? this.outstandingNoticesSql : DEFAULT_OUTSTANDING_NOTICES_SQL;
    }

    public String getPagesSent() {
        return this.pagesSent != null ? this.pagesSent : DEFAULT_PAGES_SENT;
    }

    public Queue getQueue(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.queueList.size()) {
            throw new IndexOutOfBoundsException("getQueue: Index value '" + index + "' not in range [0.." + (this.queueList.size() - 1) + "]");
        }
        return this.queueList.get(index);
    }

    public Queue[] getQueue() {
        Queue[] array = new Queue[]{};
        return this.queueList.toArray(array);
    }

    public List<Queue> getQueueCollection() {
        return this.queueList;
    }

    public int getQueueCount() {
        return this.queueList.size();
    }

    public String getServiceIdSql() {
        return this.serviceIdSql != null ? this.serviceIdSql : DEFAULT_SERVICEID_SQL;
    }

    public String getStatus() {
        return this.status;
    }

    public boolean hasMatchAll() {
        return this.matchAll != null;
    }

    public boolean hasNumericSkipResolutionPrefix() {
        return this.numericSkipResolutionPrefix != null;
    }

    public int hashCode() {
        int hash = Objects.hash(this.status, this.pagesSent, this.nextNotifId, this.nextUserNotifId, this.nextGroupId, this.serviceIdSql, this.outstandingNoticesSql, this.acknowledgeIdSql, this.acknowledgeUpdateSql, this.matchAll, this.emailAddressCommand, this.numericSkipResolutionPrefix, this.autoAcknowledgeAlarm, this.autoAcknowledgeList, this.queueList, this.outageCalendarList);
        return hash;
    }

    public Boolean isMatchAll() {
        return this.matchAll;
    }

    public Boolean isNumericSkipResolutionPrefix() {
        return this.numericSkipResolutionPrefix != null ? this.numericSkipResolutionPrefix : Boolean.valueOf("false");
    }

    public Iterator<AutoAcknowledge> iterateAutoAcknowledge() {
        return this.autoAcknowledgeList.iterator();
    }

    public Iterator<String> iterateOutageCalendar() {
        return this.outageCalendarList.iterator();
    }

    public Iterator<Queue> iterateQueue() {
        return this.queueList.iterator();
    }

    public void removeAllAutoAcknowledge() {
        this.autoAcknowledgeList.clear();
    }

    public void removeAllOutageCalendar() {
        this.outageCalendarList.clear();
    }

    public void removeAllQueue() {
        this.queueList.clear();
    }

    public boolean removeAutoAcknowledge(AutoAcknowledge vAutoAcknowledge) {
        boolean removed = this.autoAcknowledgeList.remove(vAutoAcknowledge);
        return removed;
    }

    public AutoAcknowledge removeAutoAcknowledgeAt(int index) {
        AutoAcknowledge obj = this.autoAcknowledgeList.remove(index);
        return obj;
    }

    public boolean removeOutageCalendar(String vOutageCalendar) {
        boolean removed = this.outageCalendarList.remove(vOutageCalendar);
        return removed;
    }

    public String removeOutageCalendarAt(int index) {
        String obj = this.outageCalendarList.remove(index);
        return obj;
    }

    public boolean removeQueue(Queue vQueue) {
        boolean removed = this.queueList.remove(vQueue);
        return removed;
    }

    public Queue removeQueueAt(int index) {
        Queue obj = this.queueList.remove(index);
        return obj;
    }

    public void setAcknowledgeIdSql(String acknowledgeIdSql) {
        this.acknowledgeIdSql = acknowledgeIdSql;
    }

    public void setAcknowledgeUpdateSql(String acknowledgeUpdateSql) {
        this.acknowledgeUpdateSql = acknowledgeUpdateSql;
    }

    public void setAutoAcknowledge(int index, AutoAcknowledge vAutoAcknowledge) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.autoAcknowledgeList.size()) {
            throw new IndexOutOfBoundsException("setAutoAcknowledge: Index value '" + index + "' not in range [0.." + (this.autoAcknowledgeList.size() - 1) + "]");
        }
        this.autoAcknowledgeList.set(index, vAutoAcknowledge);
    }

    public void setAutoAcknowledge(AutoAcknowledge[] vAutoAcknowledgeArray) {
        this.autoAcknowledgeList.clear();
        for (int i = 0; i < vAutoAcknowledgeArray.length; ++i) {
            this.autoAcknowledgeList.add(vAutoAcknowledgeArray[i]);
        }
    }

    public void setAutoAcknowledge(List<AutoAcknowledge> vAutoAcknowledgeList) {
        this.autoAcknowledgeList.clear();
        this.autoAcknowledgeList.addAll(vAutoAcknowledgeList);
    }

    public void setAutoAcknowledgeAlarm(AutoAcknowledgeAlarm autoAcknowledgeAlarm) {
        this.autoAcknowledgeAlarm = autoAcknowledgeAlarm;
    }

    public void setAutoAcknowledgeCollection(List<AutoAcknowledge> autoAcknowledgeList) {
        this.autoAcknowledgeList = autoAcknowledgeList;
    }

    public void setEmailAddressCommand(String emailAddressCommand) {
        this.emailAddressCommand = emailAddressCommand;
    }

    public void setMatchAll(Boolean matchAll) {
        this.matchAll = matchAll;
    }

    public void setNextGroupId(String nextGroupId) {
        this.nextGroupId = nextGroupId;
    }

    public void setNextNotifId(String nextNotifId) {
        this.nextNotifId = nextNotifId;
    }

    public void setNextUserNotifId(String nextUserNotifId) {
        this.nextUserNotifId = nextUserNotifId;
    }

    public void setNumericSkipResolutionPrefix(Boolean numericSkipResolutionPrefix) {
        this.numericSkipResolutionPrefix = numericSkipResolutionPrefix;
    }

    public void setOutageCalendar(int index, String vOutageCalendar) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.outageCalendarList.size()) {
            throw new IndexOutOfBoundsException("setOutageCalendar: Index value '" + index + "' not in range [0.." + (this.outageCalendarList.size() - 1) + "]");
        }
        this.outageCalendarList.set(index, vOutageCalendar);
    }

    public void setOutageCalendar(String[] vOutageCalendarArray) {
        this.outageCalendarList.clear();
        for (int i = 0; i < vOutageCalendarArray.length; ++i) {
            this.outageCalendarList.add(vOutageCalendarArray[i]);
        }
    }

    public void setOutageCalendar(List<String> vOutageCalendarList) {
        this.outageCalendarList.clear();
        this.outageCalendarList.addAll(vOutageCalendarList);
    }

    public void setOutageCalendarCollection(List<String> outageCalendarList) {
        this.outageCalendarList = outageCalendarList;
    }

    public void setOutstandingNoticesSql(String outstandingNoticesSql) {
        this.outstandingNoticesSql = outstandingNoticesSql;
    }

    public void setPagesSent(String pagesSent) {
        this.pagesSent = pagesSent;
    }

    public void setQueue(int index, Queue vQueue) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.queueList.size()) {
            throw new IndexOutOfBoundsException("setQueue: Index value '" + index + "' not in range [0.." + (this.queueList.size() - 1) + "]");
        }
        this.queueList.set(index, vQueue);
    }

    public void setQueue(Queue[] vQueueArray) {
        this.queueList.clear();
        for (int i = 0; i < vQueueArray.length; ++i) {
            this.queueList.add(vQueueArray[i]);
        }
    }

    public void setQueue(List<Queue> vQueueList) {
        this.queueList.clear();
        this.queueList.addAll(vQueueList);
    }

    public void setQueueCollection(List<Queue> queueList) {
        this.queueList = queueList;
    }

    public void setServiceIdSql(String serviceIdSql) {
        this.serviceIdSql = serviceIdSql;
    }

    public void setStatus(String status) {
        this.status = status;
    }
}

