/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.notifd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="auto-acknowledge-alarm")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class AutoAcknowledgeAlarm
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_RESOLUTION_PREFIX = "RESOLVED: ";
    @XmlAttribute(name="resolution-prefix")
    private String resolutionPrefix;
    @XmlAttribute(name="notify")
    private Boolean notify;
    @XmlElement(name="uei")
    private List<String> ueiList = new ArrayList<String>();

    public void addUei(String vUei) throws IndexOutOfBoundsException {
        this.ueiList.add(vUei);
    }

    public void addUei(int index, String vUei) throws IndexOutOfBoundsException {
        this.ueiList.add(index, vUei);
    }

    public void deleteNotify() {
        this.notify = null;
    }

    public Enumeration<String> enumerateUei() {
        return Collections.enumeration(this.ueiList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AutoAcknowledgeAlarm) {
            AutoAcknowledgeAlarm temp = (AutoAcknowledgeAlarm)obj;
            boolean equals = Objects.equals(temp.resolutionPrefix, this.resolutionPrefix) && Objects.equals(temp.notify, this.notify) && Objects.equals(temp.ueiList, this.ueiList);
            return equals;
        }
        return false;
    }

    public Boolean getNotify() {
        return this.notify != null ? this.notify : Boolean.valueOf("true");
    }

    public String getResolutionPrefix() {
        return this.resolutionPrefix != null ? this.resolutionPrefix : DEFAULT_RESOLUTION_PREFIX;
    }

    public String getUei(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.ueiList.size()) {
            throw new IndexOutOfBoundsException("getUei: Index value '" + index + "' not in range [0.." + (this.ueiList.size() - 1) + "]");
        }
        return this.ueiList.get(index);
    }

    public String[] getUei() {
        String[] array = new String[]{};
        return this.ueiList.toArray(array);
    }

    public List<String> getUeiCollection() {
        return this.ueiList;
    }

    public int getUeiCount() {
        return this.ueiList.size();
    }

    public boolean hasNotify() {
        return this.notify != null;
    }

    public int hashCode() {
        int hash = Objects.hash(this.resolutionPrefix, this.notify, this.ueiList);
        return hash;
    }

    public Boolean isNotify() {
        return this.notify != null ? this.notify : Boolean.valueOf("true");
    }

    public Iterator<String> iterateUei() {
        return this.ueiList.iterator();
    }

    public void removeAllUei() {
        this.ueiList.clear();
    }

    public boolean removeUei(String vUei) {
        boolean removed = this.ueiList.remove(vUei);
        return removed;
    }

    public String removeUeiAt(int index) {
        String obj = this.ueiList.remove(index);
        return obj;
    }

    public void setNotify(Boolean notify) {
        this.notify = notify;
    }

    public void setResolutionPrefix(String resolutionPrefix) {
        this.resolutionPrefix = resolutionPrefix;
    }

    public void setUei(int index, String vUei) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.ueiList.size()) {
            throw new IndexOutOfBoundsException("setUei: Index value '" + index + "' not in range [0.." + (this.ueiList.size() - 1) + "]");
        }
        this.ueiList.set(index, vUei);
    }

    public void setUei(String[] vUeiArray) {
        this.ueiList.clear();
        for (int i = 0; i < vUeiArray.length; ++i) {
            this.ueiList.add(vUeiArray[i]);
        }
    }

    public void setUei(List<String> vUeiList) {
        this.ueiList.clear();
        this.ueiList.addAll(vUeiList);
    }

    public void setUeiCollection(List<String> ueiList) {
        this.ueiList = ueiList;
    }
}

