/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.notifd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="auto-acknowledge")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class AutoAcknowledge
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_RESOLUTION_PREFIX = "RESOLVED: ";
    @XmlAttribute(name="resolution-prefix")
    private String resolutionPrefix;
    @XmlAttribute(name="uei", required=true)
    private String uei;
    @XmlAttribute(name="acknowledge", required=true)
    private String acknowledge;
    @XmlAttribute(name="notify")
    private Boolean notify;
    @XmlElement(name="match", required=true)
    private List<String> matchList = new ArrayList<String>();

    public void addMatch(String vMatch) throws IndexOutOfBoundsException {
        this.matchList.add(vMatch);
    }

    public void addMatch(int index, String vMatch) throws IndexOutOfBoundsException {
        this.matchList.add(index, vMatch);
    }

    public void deleteNotify() {
        this.notify = null;
    }

    public Enumeration<String> enumerateMatch() {
        return Collections.enumeration(this.matchList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AutoAcknowledge) {
            AutoAcknowledge temp = (AutoAcknowledge)obj;
            boolean equals = Objects.equals(temp.resolutionPrefix, this.resolutionPrefix) && Objects.equals(temp.uei, this.uei) && Objects.equals(temp.acknowledge, this.acknowledge) && Objects.equals(temp.notify, this.notify) && Objects.equals(temp.matchList, this.matchList);
            return equals;
        }
        return false;
    }

    public String getAcknowledge() {
        return this.acknowledge;
    }

    public String getMatch(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.matchList.size()) {
            throw new IndexOutOfBoundsException("getMatch: Index value '" + index + "' not in range [0.." + (this.matchList.size() - 1) + "]");
        }
        return this.matchList.get(index);
    }

    public String[] getMatch() {
        String[] array = new String[]{};
        return this.matchList.toArray(array);
    }

    public List<String> getMatchCollection() {
        return this.matchList;
    }

    public int getMatchCount() {
        return this.matchList.size();
    }

    public Boolean getNotify() {
        return this.notify != null ? this.notify : Boolean.valueOf("true");
    }

    public String getResolutionPrefix() {
        return this.resolutionPrefix != null ? this.resolutionPrefix : DEFAULT_RESOLUTION_PREFIX;
    }

    public String getUei() {
        return this.uei;
    }

    public boolean hasNotify() {
        return this.notify != null;
    }

    public int hashCode() {
        int hash = Objects.hash(this.resolutionPrefix, this.uei, this.acknowledge, this.notify, this.matchList);
        return hash;
    }

    public Boolean isNotify() {
        return this.notify != null ? this.notify : Boolean.valueOf("true");
    }

    public Iterator<String> iterateMatch() {
        return this.matchList.iterator();
    }

    public void removeAllMatch() {
        this.matchList.clear();
    }

    public boolean removeMatch(String vMatch) {
        boolean removed = this.matchList.remove(vMatch);
        return removed;
    }

    public String removeMatchAt(int index) {
        String obj = this.matchList.remove(index);
        return obj;
    }

    public void setAcknowledge(String acknowledge) {
        this.acknowledge = acknowledge;
    }

    public void setMatch(int index, String vMatch) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.matchList.size()) {
            throw new IndexOutOfBoundsException("setMatch: Index value '" + index + "' not in range [0.." + (this.matchList.size() - 1) + "]");
        }
        this.matchList.set(index, vMatch);
    }

    public void setMatch(String[] vMatchArray) {
        this.matchList.clear();
        for (int i = 0; i < vMatchArray.length; ++i) {
            this.matchList.add(vMatchArray[i]);
        }
    }

    public void setMatch(List<String> vMatchList) {
        this.matchList.clear();
        this.matchList.addAll(vMatchList);
    }

    public void setMatchCollection(List<String> matchList) {
        this.matchList = matchList;
    }

    public void setNotify(Boolean notify) {
        this.notify = notify;
    }

    public void setResolutionPrefix(String resolutionPrefix) {
        this.resolutionPrefix = resolutionPrefix;
    }

    public void setUei(String uei) {
        this.uei = uei;
    }
}

