/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.kscReports;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.config.kscReports.Graph;

@XmlRootElement(name="Report")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Report
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlAttribute(name="id")
    private Integer id;
    @XmlAttribute(name="title", required=true)
    private String title;
    @XmlAttribute(name="show_timespan_button")
    private Boolean show_timespan_button;
    @XmlAttribute(name="show_graphtype_button")
    private Boolean show_graphtype_button;
    @XmlAttribute(name="graphs_per_line")
    private Integer graphs_per_line;
    @XmlElement(name="Graph")
    private List<Graph> graphList = new ArrayList<Graph>();

    public void addGraph(Graph vGraph) throws IndexOutOfBoundsException {
        this.graphList.add(vGraph);
    }

    public void addGraph(int index, Graph vGraph) throws IndexOutOfBoundsException {
        this.graphList.add(index, vGraph);
    }

    public void deleteGraphsPerLine() {
        this.graphs_per_line = null;
    }

    public void deleteId() {
        this.id = null;
    }

    public void deleteShowGraphtypeButton() {
        this.show_graphtype_button = null;
    }

    public void deleteShowTimespanButton() {
        this.show_timespan_button = null;
    }

    public Enumeration<Graph> enumerateGraph() {
        return Collections.enumeration(this.graphList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Report) {
            Report temp = (Report)obj;
            boolean equals = Objects.equals(temp.id, this.id) && Objects.equals(temp.title, this.title) && Objects.equals(temp.show_timespan_button, this.show_timespan_button) && Objects.equals(temp.show_graphtype_button, this.show_graphtype_button) && Objects.equals(temp.graphs_per_line, this.graphs_per_line) && Objects.equals(temp.graphList, this.graphList);
            return equals;
        }
        return false;
    }

    public Graph getGraph(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.graphList.size()) {
            throw new IndexOutOfBoundsException("getGraph: Index value '" + index + "' not in range [0.." + (this.graphList.size() - 1) + "]");
        }
        return this.graphList.get(index);
    }

    public Graph[] getGraph() {
        Graph[] array = new Graph[]{};
        return this.graphList.toArray(array);
    }

    public List<Graph> getGraphCollection() {
        return this.graphList;
    }

    public int getGraphCount() {
        return this.graphList.size();
    }

    public Integer getGraphsPerLine() {
        return this.graphs_per_line;
    }

    public Integer getId() {
        return this.id;
    }

    public Boolean getShowGraphtypeButton() {
        return this.show_graphtype_button;
    }

    public Boolean getShowTimespanButton() {
        return this.show_timespan_button;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean hasGraphsPerLine() {
        return this.graphs_per_line != null;
    }

    public boolean hasId() {
        return this.id != null;
    }

    public boolean hasShowGraphtypeButton() {
        return this.show_graphtype_button != null;
    }

    public boolean hasShowTimespanButton() {
        return this.show_timespan_button != null;
    }

    public int hashCode() {
        int hash = Objects.hash(this.id, this.title, this.show_timespan_button, this.show_graphtype_button, this.graphs_per_line, this.graphList);
        return hash;
    }

    public Boolean isShowGraphtypeButton() {
        return this.show_graphtype_button;
    }

    public Boolean isShowTimespanButton() {
        return this.show_timespan_button;
    }

    public Iterator<Graph> iterateGraph() {
        return this.graphList.iterator();
    }

    public void removeAllGraph() {
        this.graphList.clear();
    }

    public boolean removeGraph(Graph vGraph) {
        boolean removed = this.graphList.remove(vGraph);
        return removed;
    }

    public Graph removeGraphAt(int index) {
        Graph obj = this.graphList.remove(index);
        return obj;
    }

    public void setGraph(int index, Graph vGraph) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.graphList.size()) {
            throw new IndexOutOfBoundsException("setGraph: Index value '" + index + "' not in range [0.." + (this.graphList.size() - 1) + "]");
        }
        this.graphList.set(index, vGraph);
    }

    public void setGraph(Graph[] vGraphArray) {
        this.graphList.clear();
        for (int i = 0; i < vGraphArray.length; ++i) {
            this.graphList.add(vGraphArray[i]);
        }
    }

    public void setGraph(List<Graph> vGraphList) {
        this.graphList.clear();
        this.graphList.addAll(vGraphList);
    }

    public void setGraphCollection(List<Graph> graphList) {
        this.graphList = graphList;
    }

    public void setGraphsPerLine(Integer graphs_per_line) {
        this.graphs_per_line = graphs_per_line;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setShowGraphtypeButton(Boolean show_graphtype_button) {
        this.show_graphtype_button = show_graphtype_button;
    }

    public void setShowTimespanButton(Boolean show_timespan_button) {
        this.show_timespan_button = show_timespan_button;
    }

    public void setTitle(String title) {
        this.title = title;
    }
}

