/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.filter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.config.filter.Alias;
import org.opennms.netmgt.config.filter.Constraint;

@XmlRootElement(name="column")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Column
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_VISISBLE = "true";
    @XmlAttribute(name="name", required=true)
    private String name;
    @XmlAttribute(name="sql-type")
    private String sqlType;
    @XmlAttribute(name="java-type")
    private String javaType;
    @XmlAttribute(name="visible")
    private String visible;
    @XmlElement(name="alias")
    private List<Alias> aliasList = new ArrayList<Alias>();
    @XmlElement(name="constraint")
    private List<Constraint> constraintList = new ArrayList<Constraint>();

    public void addAlias(Alias vAlias) throws IndexOutOfBoundsException {
        this.aliasList.add(vAlias);
    }

    public void addAlias(int index, Alias vAlias) throws IndexOutOfBoundsException {
        this.aliasList.add(index, vAlias);
    }

    public void addConstraint(Constraint vConstraint) throws IndexOutOfBoundsException {
        this.constraintList.add(vConstraint);
    }

    public void addConstraint(int index, Constraint vConstraint) throws IndexOutOfBoundsException {
        this.constraintList.add(index, vConstraint);
    }

    public Enumeration<Alias> enumerateAlias() {
        return Collections.enumeration(this.aliasList);
    }

    public Enumeration<Constraint> enumerateConstraint() {
        return Collections.enumeration(this.constraintList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Column) {
            Column temp = (Column)obj;
            boolean equals = Objects.equals(temp.name, this.name) && Objects.equals(temp.sqlType, this.sqlType) && Objects.equals(temp.javaType, this.javaType) && Objects.equals(temp.visible, this.visible) && Objects.equals(temp.aliasList, this.aliasList) && Objects.equals(temp.constraintList, this.constraintList);
            return equals;
        }
        return false;
    }

    public Alias getAlias(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.aliasList.size()) {
            throw new IndexOutOfBoundsException("getAlias: Index value '" + index + "' not in range [0.." + (this.aliasList.size() - 1) + "]");
        }
        return this.aliasList.get(index);
    }

    public Alias[] getAlias() {
        Alias[] array = new Alias[]{};
        return this.aliasList.toArray(array);
    }

    public List<Alias> getAliasCollection() {
        return this.aliasList;
    }

    public int getAliasCount() {
        return this.aliasList.size();
    }

    public Constraint getConstraint(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.constraintList.size()) {
            throw new IndexOutOfBoundsException("getConstraint: Index value '" + index + "' not in range [0.." + (this.constraintList.size() - 1) + "]");
        }
        return this.constraintList.get(index);
    }

    public Constraint[] getConstraint() {
        Constraint[] array = new Constraint[]{};
        return this.constraintList.toArray(array);
    }

    public List<Constraint> getConstraintCollection() {
        return this.constraintList;
    }

    public int getConstraintCount() {
        return this.constraintList.size();
    }

    public String getJavaType() {
        return this.javaType;
    }

    public String getName() {
        return this.name;
    }

    public String getSqlType() {
        return this.sqlType;
    }

    public String getVisible() {
        return this.visible != null ? this.visible : DEFAULT_VISISBLE;
    }

    public int hashCode() {
        int hash = Objects.hash(this.name, this.sqlType, this.javaType, this.visible, this.aliasList, this.constraintList);
        return hash;
    }

    public Iterator<Alias> iterateAlias() {
        return this.aliasList.iterator();
    }

    public Iterator<Constraint> iterateConstraint() {
        return this.constraintList.iterator();
    }

    public boolean removeAlias(Alias vAlias) {
        boolean removed = this.aliasList.remove(vAlias);
        return removed;
    }

    public Alias removeAliasAt(int index) {
        Alias obj = this.aliasList.remove(index);
        return obj;
    }

    public void removeAllAlias() {
        this.aliasList.clear();
    }

    public void removeAllConstraint() {
        this.constraintList.clear();
    }

    public boolean removeConstraint(Constraint vConstraint) {
        boolean removed = this.constraintList.remove(vConstraint);
        return removed;
    }

    public Constraint removeConstraintAt(int index) {
        Constraint obj = this.constraintList.remove(index);
        return obj;
    }

    public void setAlias(int index, Alias vAlias) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.aliasList.size()) {
            throw new IndexOutOfBoundsException("setAlias: Index value '" + index + "' not in range [0.." + (this.aliasList.size() - 1) + "]");
        }
        this.aliasList.set(index, vAlias);
    }

    public void setAlias(Alias[] vAliasArray) {
        this.aliasList.clear();
        for (int i = 0; i < vAliasArray.length; ++i) {
            this.aliasList.add(vAliasArray[i]);
        }
    }

    public void setAlias(List<Alias> vAliasList) {
        this.aliasList.clear();
        this.aliasList.addAll(vAliasList);
    }

    public void setAliasCollection(List<Alias> aliasList) {
        this.aliasList = aliasList;
    }

    public void setConstraint(int index, Constraint vConstraint) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.constraintList.size()) {
            throw new IndexOutOfBoundsException("setConstraint: Index value '" + index + "' not in range [0.." + (this.constraintList.size() - 1) + "]");
        }
        this.constraintList.set(index, vConstraint);
    }

    public void setConstraint(Constraint[] vConstraintArray) {
        this.constraintList.clear();
        for (int i = 0; i < vConstraintArray.length; ++i) {
            this.constraintList.add(vConstraintArray[i]);
        }
    }

    public void setConstraint(List<Constraint> vConstraintList) {
        this.constraintList.clear();
        this.constraintList.addAll(vConstraintList);
    }

    public void setConstraintCollection(List<Constraint> constraintList) {
        this.constraintList = constraintList;
    }

    public void setJavaType(String javaType) {
        this.javaType = javaType;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSqlType(String sqlType) {
        this.sqlType = sqlType;
    }

    public void setVisible(String visible) {
        this.visible = visible;
    }
}

