/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.discovery;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.opennms.core.xml.DoubleAdapter;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.discovery.ExcludeRange;
import org.opennms.netmgt.config.discovery.IncludeRange;
import org.opennms.netmgt.config.discovery.IncludeUrl;
import org.opennms.netmgt.config.discovery.Specific;

@XmlRootElement(name="discovery-configuration")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="discovery-configuration.xsd")
public class DiscoveryConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlAttribute(name="location")
    private String m_location;
    @XmlAttribute(name="packets-per-second", required=true)
    @XmlJavaTypeAdapter(value=DoubleAdapter.class)
    private Double m_packetsPerSecond;
    @XmlAttribute(name="initial-sleep-time", required=true)
    private Long m_initialSleepTime;
    @XmlAttribute(name="restart-sleep-time", required=true)
    private Long m_restartSleepTime;
    @XmlAttribute(name="retries")
    private Integer m_retries;
    @XmlAttribute(name="timeout")
    private Long m_timeout;
    @XmlAttribute(name="foreign-source")
    private String m_foreignSource;
    @XmlAttribute(name="chunk-size")
    private Integer m_chunkSize;
    @XmlElement(name="specific")
    private List<Specific> m_specifics = new ArrayList<Specific>();
    @XmlElement(name="include-range")
    private List<IncludeRange> m_includeRanges = new ArrayList<IncludeRange>();
    @XmlElement(name="exclude-range")
    private List<ExcludeRange> m_excludeRanges = new ArrayList<ExcludeRange>();
    @XmlElement(name="include-url")
    private List<IncludeUrl> m_includeUrls = new ArrayList<IncludeUrl>();

    public Optional<String> getLocation() {
        return Optional.ofNullable(this.m_location);
    }

    public void setLocation(String location) {
        this.m_location = location;
    }

    public Optional<Double> getPacketsPerSecond() {
        return Optional.ofNullable(this.m_packetsPerSecond);
    }

    public void setPacketsPerSecond(Double packetsPerSecond) {
        this.m_packetsPerSecond = packetsPerSecond;
    }

    public Optional<Long> getInitialSleepTime() {
        return Optional.ofNullable(this.m_initialSleepTime);
    }

    public void setInitialSleepTime(Long initialSleepTime) {
        this.m_initialSleepTime = initialSleepTime;
    }

    public Optional<Long> getRestartSleepTime() {
        return Optional.ofNullable(this.m_restartSleepTime);
    }

    public void setRestartSleepTime(Long restartSleepTime) {
        this.m_restartSleepTime = restartSleepTime;
    }

    public Optional<Integer> getRetries() {
        return Optional.ofNullable(this.m_retries);
    }

    public void setRetries(Integer retries) {
        this.m_retries = retries;
    }

    public Optional<Long> getTimeout() {
        return Optional.ofNullable(this.m_timeout);
    }

    public void setTimeout(Long timeout) {
        if (timeout != null && timeout == 0L) {
            throw new IllegalArgumentException("Can't have a 0 timeout!");
        }
        this.m_timeout = timeout;
    }

    public Optional<String> getForeignSource() {
        return Optional.ofNullable(this.m_foreignSource);
    }

    public void setForeignSource(String foreignSource) {
        this.m_foreignSource = foreignSource;
    }

    public Optional<Integer> getChunkSize() {
        return Optional.ofNullable(this.m_chunkSize);
    }

    public void setChunkSize(Integer chunkSize) {
        this.m_chunkSize = chunkSize;
    }

    public List<Specific> getSpecifics() {
        return this.m_specifics;
    }

    public Specific getSpecific(int index) {
        return this.getSpecifics().get(index);
    }

    public void setSpecifics(List<Specific> specifics) {
        this.m_specifics.clear();
        this.m_specifics.addAll(specifics);
    }

    public void addSpecific(Specific specific) {
        this.m_specifics.add(specific);
    }

    public boolean removeSpecific(Specific specific) {
        return this.m_specifics.remove(specific);
    }

    public void clearSpecifics() {
        this.m_specifics.clear();
    }

    public List<IncludeRange> getIncludeRanges() {
        return this.m_includeRanges;
    }

    public IncludeRange getIncludeRange(int index) {
        return this.getIncludeRanges().get(index);
    }

    public void setIncludeRanges(List<IncludeRange> includeRanges) {
        this.m_includeRanges.clear();
        this.m_includeRanges.addAll(includeRanges);
    }

    public void addIncludeRange(IncludeRange includeRange) {
        this.m_includeRanges.add(includeRange);
    }

    public boolean removeIncludeRange(IncludeRange includeRange) {
        return this.m_includeRanges.remove(includeRange);
    }

    public void clearIncludeRanges() {
        this.m_includeRanges.clear();
    }

    public List<ExcludeRange> getExcludeRanges() {
        return this.m_excludeRanges;
    }

    public ExcludeRange getExcludeRange(int index) {
        return this.getExcludeRanges().get(index);
    }

    public void setExcludeRanges(List<ExcludeRange> excludeRanges) {
        this.m_excludeRanges.clear();
        this.m_excludeRanges.addAll(excludeRanges);
    }

    public void addExcludeRange(ExcludeRange excludeRange) {
        this.m_excludeRanges.add(excludeRange);
    }

    public boolean removeExcludeRange(ExcludeRange excludeRange) {
        return this.m_excludeRanges.remove(excludeRange);
    }

    public void clearExcludeRanges() {
        this.m_excludeRanges.clear();
    }

    public List<IncludeUrl> getIncludeUrls() {
        return this.m_includeUrls;
    }

    public IncludeUrl getIncludeUrl(int index) {
        return this.getIncludeUrls().get(index);
    }

    public void setIncludeUrls(List<IncludeUrl> includeUrls) {
        this.m_includeUrls.clear();
        this.m_includeUrls.addAll(includeUrls);
    }

    public void addIncludeUrl(IncludeUrl includeUrl) {
        this.m_includeUrls.add(includeUrl);
    }

    public boolean removeIncludeUrl(IncludeUrl includeUrl) {
        return this.m_includeUrls.remove(includeUrl);
    }

    public void clearIncludeUrls() {
        this.m_includeUrls.clear();
    }

    public int hashCode() {
        return Objects.hash(this.m_location, this.m_packetsPerSecond, this.m_initialSleepTime, this.m_restartSleepTime, this.m_retries, this.m_timeout, this.m_foreignSource, this.m_chunkSize, this.m_specifics, this.m_includeRanges, this.m_excludeRanges, this.m_includeUrls);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DiscoveryConfiguration) {
            DiscoveryConfiguration temp = (DiscoveryConfiguration)obj;
            return Objects.equals(temp.m_location, this.m_location) && Objects.equals(temp.m_packetsPerSecond, this.m_packetsPerSecond) && Objects.equals(temp.m_initialSleepTime, this.m_initialSleepTime) && Objects.equals(temp.m_restartSleepTime, this.m_restartSleepTime) && Objects.equals(temp.m_retries, this.m_retries) && Objects.equals(temp.m_timeout, this.m_timeout) && Objects.equals(temp.m_foreignSource, this.m_foreignSource) && Objects.equals(temp.m_chunkSize, this.m_chunkSize) && Objects.equals(temp.m_specifics, this.m_specifics) && Objects.equals(temp.m_includeRanges, this.m_includeRanges) && Objects.equals(temp.m_excludeRanges, this.m_excludeRanges) && Objects.equals(temp.m_includeUrls, this.m_includeUrls);
        }
        return false;
    }

    public String toString() {
        return "DiscoveryConfiguration [location=" + this.m_location + ", packetsPerSecond=" + this.m_packetsPerSecond + ", initialSleepTime=" + this.m_initialSleepTime + ", restartSleepTime=" + this.m_restartSleepTime + ", retries=" + this.m_retries + ", timeout=" + this.m_timeout + ", foreignSource=" + this.m_foreignSource + ", chunkSize=" + this.m_chunkSize + ", specifics=" + this.m_specifics + ", includeRanges=" + this.m_includeRanges + ", excludeRanges=" + this.m_excludeRanges + ", includeUrls=" + this.m_includeUrls + "]";
    }
}

