/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.destinationPaths;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.destinationPaths.Escalate;
import org.opennms.netmgt.config.destinationPaths.Target;

@XmlRootElement(name="path")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="destinationPaths.xsd")
public class Path
implements Serializable {
    public static final String DEFAULT_INITIAL_DELAY = "0s";
    private static final long serialVersionUID = 1L;
    @XmlAttribute(name="name", required=true)
    private String m_name;
    @XmlAttribute(name="initial-delay")
    private String m_initialDelay;
    @XmlElement(name="target", required=true)
    private List<Target> m_targets = new ArrayList<Target>();
    @XmlElement(name="escalate")
    private List<Escalate> m_escalates = new ArrayList<Escalate>();

    public Path() {
    }

    public Path(String name) {
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getInitialDelay() {
        return this.m_initialDelay;
    }

    public void setInitialDelay(String initialDelay) {
        this.m_initialDelay = initialDelay;
    }

    public List<Target> getTargets() {
        return this.m_targets;
    }

    public void setTargets(List<Target> targets) {
        this.m_targets.clear();
        this.m_targets.addAll(targets);
    }

    public void addTarget(Target target) {
        this.m_targets.add(target);
    }

    public boolean removeTarget(Target target) {
        return this.m_targets.remove(target);
    }

    public void clearTargets() {
        this.m_targets.clear();
    }

    public List<Escalate> getEscalates() {
        return this.m_escalates;
    }

    public void setEscalates(List<Escalate> escalates) {
        this.m_escalates.clear();
        this.m_escalates.addAll(escalates);
    }

    public void addEscalate(Escalate escalate) {
        this.m_escalates.add(escalate);
    }

    public void addEscalate(int index, Escalate escalate) {
        this.m_escalates.add(index, escalate);
    }

    public boolean removeEscalate(Escalate escalate) {
        return this.m_escalates.remove(escalate);
    }

    public void clearEscalates() {
        this.m_escalates.clear();
    }

    public int hashCode() {
        return Objects.hash(this.m_name, this.m_initialDelay, this.m_targets, this.m_escalates);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Path) {
            Path temp = (Path)obj;
            return Objects.equals(temp.m_name, this.m_name) && Objects.equals(temp.m_initialDelay, this.m_initialDelay) && Objects.equals(temp.m_targets, this.m_targets) && Objects.equals(temp.m_escalates, this.m_escalates);
        }
        return false;
    }

    public String toString() {
        return "Path [name=" + this.m_name + ", initialDelay=" + this.m_initialDelay + ", targets=" + this.m_targets + ", escalates=" + this.m_escalates + "]";
    }
}

