/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.categories;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;

@XmlRootElement(name="category")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="categories.xsd")
public class Category
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="label", required=true)
    private String m_label;
    @XmlElement(name="comment")
    private String m_comment;
    @XmlElement(name="normal", required=true)
    private Double m_normalThreshold;
    @XmlElement(name="warning", required=true)
    private Double m_warningThreshold;
    @XmlElement(name="service")
    private List<String> m_services = new ArrayList<String>();
    @XmlElement(name="rule", required=true)
    private String m_rule;

    public Category() {
    }

    public Category(String label, String comment, Double normalThreshold, Double warningThreshold, String rule, String ... services) {
        this.m_label = label;
        this.m_comment = comment;
        this.m_normalThreshold = normalThreshold;
        this.m_warningThreshold = warningThreshold;
        this.m_rule = rule;
        this.m_services.addAll(Arrays.asList(services));
    }

    public String getLabel() {
        Objects.requireNonNull(this.m_label);
        return this.m_label;
    }

    public void setLabel(String label) {
        this.m_label = label;
    }

    public String getComment() {
        return this.m_comment;
    }

    public void setComment(String comment) {
        this.m_comment = comment;
    }

    public Double getNormalThreshold() {
        Objects.requireNonNull(this.m_normalThreshold);
        return this.m_normalThreshold;
    }

    public void setNormalThreshold(Double normal) {
        this.m_normalThreshold = normal;
    }

    public Double getWarningThreshold() {
        Objects.requireNonNull(this.m_warningThreshold);
        return this.m_warningThreshold;
    }

    public void setWarningThreshold(Double warning) {
        this.m_warningThreshold = warning;
    }

    public List<String> getServices() {
        return this.m_services;
    }

    public void setServices(List<String> services) {
        this.m_services.clear();
        this.m_services.addAll(services);
    }

    public void addService(String service) {
        this.m_services.add(service);
    }

    public void clearServices() {
        this.m_services.clear();
    }

    public String getRule() {
        return this.m_rule;
    }

    public void setRule(String rule) {
        this.m_rule = rule;
    }

    public boolean isValid() {
        return Objects.nonNull(this.m_label) && Objects.nonNull(this.m_normalThreshold) && Objects.nonNull(this.m_warningThreshold);
    }

    public int hashCode() {
        return Objects.hash(this.m_label, this.m_comment, this.m_normalThreshold, this.m_warningThreshold, this.m_services, this.m_rule);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Category) {
            Category temp = (Category)obj;
            return Objects.equals(temp.m_label, this.m_label) && Objects.equals(temp.m_comment, this.m_comment) && Objects.equals(temp.m_normalThreshold, this.m_normalThreshold) && Objects.equals(temp.m_warningThreshold, this.m_warningThreshold) && Objects.equals(temp.m_services, this.m_services) && Objects.equals(temp.m_rule, this.m_rule);
        }
        return false;
    }
}

