/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.translator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.config.translator.Assignment;

@XmlRootElement(name="mapping")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Mapping
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlAttribute(name="preserve-snmp-data")
    private Boolean preserveSnmpData;
    @XmlElement(name="assignment")
    private List<Assignment> assignmentList = new ArrayList<Assignment>();

    public void addAssignment(Assignment vAssignment) throws IndexOutOfBoundsException {
        this.assignmentList.add(vAssignment);
    }

    public void addAssignment(int index, Assignment vAssignment) throws IndexOutOfBoundsException {
        this.assignmentList.add(index, vAssignment);
    }

    public void deletePreserveSnmpData() {
        this.preserveSnmpData = null;
    }

    public Enumeration<Assignment> enumerateAssignment() {
        return Collections.enumeration(this.assignmentList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Mapping) {
            Mapping temp = (Mapping)obj;
            boolean equals = Objects.equals(temp.preserveSnmpData, this.preserveSnmpData) && Objects.equals(temp.assignmentList, this.assignmentList);
            return equals;
        }
        return false;
    }

    public Assignment getAssignment(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.assignmentList.size()) {
            throw new IndexOutOfBoundsException("getAssignment: Index value '" + index + "' not in range [0.." + (this.assignmentList.size() - 1) + "]");
        }
        return this.assignmentList.get(index);
    }

    public Assignment[] getAssignment() {
        Assignment[] array = new Assignment[]{};
        return this.assignmentList.toArray(array);
    }

    public List<Assignment> getAssignmentCollection() {
        return this.assignmentList;
    }

    public int getAssignmentCount() {
        return this.assignmentList.size();
    }

    public Boolean getPreserveSnmpData() {
        return this.preserveSnmpData != null ? this.preserveSnmpData : Boolean.valueOf("false");
    }

    public boolean hasPreserveSnmpData() {
        return this.preserveSnmpData != null;
    }

    public int hashCode() {
        int hash = Objects.hash(this.preserveSnmpData, this.assignmentList);
        return hash;
    }

    public Boolean isPreserveSnmpData() {
        return this.preserveSnmpData != null ? this.preserveSnmpData : Boolean.valueOf("false");
    }

    public Iterator<Assignment> iterateAssignment() {
        return this.assignmentList.iterator();
    }

    public void removeAllAssignment() {
        this.assignmentList.clear();
    }

    public boolean removeAssignment(Assignment vAssignment) {
        boolean removed = this.assignmentList.remove(vAssignment);
        return removed;
    }

    public Assignment removeAssignmentAt(int index) {
        Assignment obj = this.assignmentList.remove(index);
        return obj;
    }

    public void setAssignment(int index, Assignment vAssignment) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.assignmentList.size()) {
            throw new IndexOutOfBoundsException("setAssignment: Index value '" + index + "' not in range [0.." + (this.assignmentList.size() - 1) + "]");
        }
        this.assignmentList.set(index, vAssignment);
    }

    public void setAssignment(Assignment[] vAssignmentArray) {
        this.assignmentList.clear();
        for (int i = 0; i < vAssignmentArray.length; ++i) {
            this.assignmentList.add(vAssignmentArray[i]);
        }
    }

    public void setAssignment(List<Assignment> vAssignmentList) {
        this.assignmentList.clear();
        this.assignmentList.addAll(vAssignmentList);
    }

    public void setAssignmentCollection(List<Assignment> assignmentList) {
        this.assignmentList = assignmentList;
    }

    public void setPreserveSnmpData(Boolean preserveSnmpData) {
        this.preserveSnmpData = preserveSnmpData;
    }
}

