/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.surveillanceViews;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.config.surveillanceViews.Category;
import org.opennms.netmgt.config.surveillanceViews.ColumnDef;

@XmlRootElement(name="columns")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Columns
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="column-def", required=true)
    private List<ColumnDef> columnDefList = new ArrayList<ColumnDef>();

    public ColumnDef addColumn(String columnLabel, String categoryName) {
        ColumnDef colDef = new ColumnDef();
        colDef.setLabel(columnLabel);
        Category category = new Category();
        category.setName(categoryName);
        colDef.addCategory(category);
        this.addColumnDef(colDef);
        return colDef;
    }

    public void addColumnDef(ColumnDef vColumnDef) throws IndexOutOfBoundsException {
        this.columnDefList.add(vColumnDef);
    }

    public void addColumnDef(int index, ColumnDef vColumnDef) throws IndexOutOfBoundsException {
        this.columnDefList.add(index, vColumnDef);
    }

    public Enumeration<ColumnDef> enumerateColumnDef() {
        return Collections.enumeration(this.columnDefList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Columns) {
            Columns temp = (Columns)obj;
            boolean equals = Objects.equals(temp.columnDefList, this.columnDefList);
            return equals;
        }
        return false;
    }

    public ColumnDef getColumnDef(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.columnDefList.size()) {
            throw new IndexOutOfBoundsException("getColumnDef: Index value '" + index + "' not in range [0.." + (this.columnDefList.size() - 1) + "]");
        }
        return this.columnDefList.get(index);
    }

    public ColumnDef[] getColumnDef() {
        ColumnDef[] array = new ColumnDef[]{};
        return this.columnDefList.toArray(array);
    }

    public List<ColumnDef> getColumnDefCollection() {
        return this.columnDefList;
    }

    public int getColumnDefCount() {
        return this.columnDefList.size();
    }

    public int hashCode() {
        int hash = Objects.hash(this.columnDefList);
        return hash;
    }

    public Iterator<ColumnDef> iterateColumnDef() {
        return this.columnDefList.iterator();
    }

    public void removeAllColumnDef() {
        this.columnDefList.clear();
    }

    public boolean removeColumnDef(ColumnDef vColumnDef) {
        boolean removed = this.columnDefList.remove(vColumnDef);
        return removed;
    }

    public ColumnDef removeColumnDefAt(int index) {
        ColumnDef obj = this.columnDefList.remove(index);
        return obj;
    }

    public void setColumnDef(int index, ColumnDef vColumnDef) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.columnDefList.size()) {
            throw new IndexOutOfBoundsException("setColumnDef: Index value '" + index + "' not in range [0.." + (this.columnDefList.size() - 1) + "]");
        }
        this.columnDefList.set(index, vColumnDef);
    }

    public void setColumnDef(ColumnDef[] vColumnDefArray) {
        this.columnDefList.clear();
        for (int i = 0; i < vColumnDefArray.length; ++i) {
            this.columnDefList.add(vColumnDefArray[i]);
        }
    }

    public void setColumnDef(List<ColumnDef> vColumnDefList) {
        this.columnDefList.clear();
        this.columnDefList.addAll(vColumnDefList);
    }

    public void setColumnDefCollection(List<ColumnDef> columnDefList) {
        this.columnDefList = columnDefList;
    }
}

