/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.rws;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.config.rws.BaseUrl;
import org.opennms.netmgt.config.rws.StandbyUrl;

@XmlRootElement(name="rws-configuration")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RwsConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="base-url", required=true)
    private BaseUrl baseUrl;
    @XmlElement(name="standby-url")
    private List<StandbyUrl> standbyUrlList = new ArrayList<StandbyUrl>();

    public void addStandbyUrl(StandbyUrl vStandbyUrl) throws IndexOutOfBoundsException {
        this.standbyUrlList.add(vStandbyUrl);
    }

    public void addStandbyUrl(int index, StandbyUrl vStandbyUrl) throws IndexOutOfBoundsException {
        this.standbyUrlList.add(index, vStandbyUrl);
    }

    public Enumeration<StandbyUrl> enumerateStandbyUrl() {
        return Collections.enumeration(this.standbyUrlList);
    }

    public BaseUrl getBaseUrl() {
        return this.baseUrl;
    }

    public StandbyUrl getStandbyUrl(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.standbyUrlList.size()) {
            throw new IndexOutOfBoundsException("getStandbyUrl: Index value '" + index + "' not in range [0.." + (this.standbyUrlList.size() - 1) + "]");
        }
        return this.standbyUrlList.get(index);
    }

    public StandbyUrl[] getStandbyUrl() {
        StandbyUrl[] array = new StandbyUrl[]{};
        return this.standbyUrlList.toArray(array);
    }

    public List<StandbyUrl> getStandbyUrlCollection() {
        return this.standbyUrlList;
    }

    public int getStandbyUrlCount() {
        return this.standbyUrlList.size();
    }

    public Iterator<StandbyUrl> iterateStandbyUrl() {
        return this.standbyUrlList.iterator();
    }

    public void removeAllStandbyUrl() {
        this.standbyUrlList.clear();
    }

    public boolean removeStandbyUrl(StandbyUrl vStandbyUrl) {
        boolean removed = this.standbyUrlList.remove(vStandbyUrl);
        return removed;
    }

    public StandbyUrl removeStandbyUrlAt(int index) {
        StandbyUrl obj = this.standbyUrlList.remove(index);
        return obj;
    }

    public void setBaseUrl(BaseUrl baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void setStandbyUrl(int index, StandbyUrl vStandbyUrl) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.standbyUrlList.size()) {
            throw new IndexOutOfBoundsException("setStandbyUrl: Index value '" + index + "' not in range [0.." + (this.standbyUrlList.size() - 1) + "]");
        }
        this.standbyUrlList.set(index, vStandbyUrl);
    }

    public void setStandbyUrl(StandbyUrl[] vStandbyUrlArray) {
        this.standbyUrlList.clear();
        for (int i = 0; i < vStandbyUrlArray.length; ++i) {
            this.standbyUrlList.add(vStandbyUrlArray[i]);
        }
    }

    public void setStandbyUrl(List<StandbyUrl> vStandbyUrlList) {
        this.standbyUrlList.clear();
        this.standbyUrlList.addAll(vStandbyUrlList);
    }

    public void setStandbyUrlCollection(List<StandbyUrl> standbyUrlList) {
        this.standbyUrlList = standbyUrlList;
    }

    public boolean equals(Object other) {
        if (!(other instanceof RwsConfiguration)) {
            return false;
        }
        RwsConfiguration castOther = (RwsConfiguration)other;
        return Objects.equals(this.baseUrl, castOther.baseUrl) && Objects.equals(this.standbyUrlList, castOther.standbyUrlList);
    }

    public int hashCode() {
        return Objects.hash(this.baseUrl, this.standbyUrlList);
    }
}

