/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.poller.outages;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.poller.outages.Outage;

@XmlRootElement(name="outages", namespace="http://xmlns.opennms.org/xsd/config/poller/outages")
@XmlAccessorType(value=XmlAccessType.NONE)
@ValidateUsing(value="poll-outages.xsd")
public class Outages
implements Serializable {
    private static final Outage[] EMPTY_OUTAGE_LIST = new Outage[0];
    private static final long serialVersionUID = 2135204624761990598L;
    private Map<String, Outage> _outageMap = new LinkedHashMap<String, Outage>();

    public void addOutage(Outage vOutage) throws IndexOutOfBoundsException {
        this._outageMap.put(vOutage.getName(), vOutage);
    }

    public void addOutage(int index, Outage vOutage) throws IndexOutOfBoundsException {
        ArrayList<Outage> outageList = new ArrayList<Outage>(this._outageMap.values());
        outageList.add(index, vOutage);
        this.setOutage(outageList);
    }

    public Enumeration<Outage> enumerateOutage() {
        return Collections.enumeration(this._outageMap.values());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Outages) {
            Outages temp = (Outages)obj;
            if (this._outageMap != null) {
                if (temp._outageMap == null) {
                    return false;
                }
                if (!this._outageMap.equals(temp._outageMap)) {
                    return false;
                }
            } else if (temp._outageMap != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public Outage getOutage(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._outageMap.size()) {
            throw new IndexOutOfBoundsException("getOutage: Index value '" + index + "' not in range [0.." + (this._outageMap.size() - 1) + "]");
        }
        int count = 0;
        for (Outage o : this._outageMap.values()) {
            if (count == index) {
                return o;
            }
            ++count;
        }
        return null;
    }

    @XmlElement(name="outage")
    public Outage[] getOutage() {
        return this._outageMap.values().toArray(EMPTY_OUTAGE_LIST);
    }

    public List<Outage> getOutageCollection() {
        return new ArrayList<Outage>(this._outageMap.values());
    }

    public int getOutageCount() {
        return this._outageMap.size();
    }

    public int hashCode() {
        int result = 17;
        if (this._outageMap != null) {
            result = 37 * result + this._outageMap.hashCode();
        }
        return result;
    }

    public Iterator<Outage> iterateOutage() {
        return this._outageMap.values().iterator();
    }

    public void removeAllOutage() {
        this._outageMap.clear();
    }

    public boolean removeOutage(Outage vOutage) {
        Outage removed = this._outageMap.remove(vOutage.getName());
        return removed != null;
    }

    public Outage removeOutageAt(int index) {
        ArrayList<Outage> outageList = new ArrayList<Outage>(this._outageMap.values());
        Outage o = (Outage)outageList.remove(index);
        this.setOutage(outageList);
        return o;
    }

    public void setOutage(int index, Outage vOutage) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._outageMap.size()) {
            throw new IndexOutOfBoundsException("setOutage: Index value '" + index + "' not in range [0.." + (this._outageMap.size() - 1) + "]");
        }
        ArrayList<Outage> outageList = new ArrayList<Outage>(this._outageMap.values());
        outageList.set(index, vOutage);
        this.setOutage(outageList);
    }

    public void setOutage(Outage[] vOutageArray) {
        this.setOutage(Arrays.asList(vOutageArray));
    }

    public void setOutage(List<Outage> vOutageList) {
        LinkedHashMap<String, Outage> m = new LinkedHashMap<String, Outage>();
        for (Outage o : vOutageList) {
            m.put(o.getName(), o);
        }
        this._outageMap = m;
    }

    public void setOutageCollection(List<Outage> outageList) {
        this.setOutage(outageList);
    }

    public Outage getOutage(String name) {
        return this._outageMap.get(name);
    }

    public void removeOutage(String outageName) {
        this._outageMap.remove(outageName);
    }
}

