/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.charts;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.config.charts.ChartBackgroundColor;
import org.opennms.netmgt.config.charts.GridLines;
import org.opennms.netmgt.config.charts.ImageSize;
import org.opennms.netmgt.config.charts.PlotBackgroundColor;
import org.opennms.netmgt.config.charts.SeriesDef;
import org.opennms.netmgt.config.charts.SubTitle;
import org.opennms.netmgt.config.charts.Title;

@XmlRootElement(name="bar-chart")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class BarChart
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlAttribute(name="name", required=true)
    private String name;
    @XmlAttribute(name="domain-axis-label", required=true)
    private String domainAxisLabel;
    @XmlAttribute(name="range-axis-label", required=true)
    private String rangeAxisLabel;
    @XmlAttribute(name="sub-label-class")
    private String subLabelClass;
    @XmlAttribute(name="series-color-class")
    private String seriesColorClass;
    @XmlAttribute(name="draw-bar-outline")
    private Boolean drawBarOutline;
    @XmlAttribute(name="show-legend")
    private Boolean showLegend;
    @XmlAttribute(name="show-tool-tips")
    private Boolean showToolTips;
    @XmlAttribute(name="show-urls")
    private Boolean showUrls;
    @XmlAttribute(name="variation")
    private String variation;
    @XmlAttribute(name="plot-orientation")
    private String plotOrientation;
    @XmlElement(name="title", required=true)
    private Title title;
    @XmlElement(name="image-size", required=true)
    private ImageSize imageSize;
    @XmlElement(name="sub-title")
    private List<SubTitle> subTitleList = new ArrayList<SubTitle>();
    @XmlElement(name="grid-lines")
    private GridLines gridLines;
    @XmlElement(name="series-def")
    private List<SeriesDef> seriesDefList = new ArrayList<SeriesDef>();
    @XmlElement(name="plot-background-color")
    private PlotBackgroundColor plotBackgroundColor;
    @XmlElement(name="chart-background-color")
    private ChartBackgroundColor chartBackgroundColor;

    public void addSeriesDef(SeriesDef vSeriesDef) throws IndexOutOfBoundsException {
        this.seriesDefList.add(vSeriesDef);
    }

    public void addSeriesDef(int index, SeriesDef vSeriesDef) throws IndexOutOfBoundsException {
        this.seriesDefList.add(index, vSeriesDef);
    }

    public void addSubTitle(SubTitle vSubTitle) throws IndexOutOfBoundsException {
        this.subTitleList.add(vSubTitle);
    }

    public void addSubTitle(int index, SubTitle vSubTitle) throws IndexOutOfBoundsException {
        this.subTitleList.add(index, vSubTitle);
    }

    public void deleteDrawBarOutline() {
        this.drawBarOutline = null;
    }

    public void deleteShowLegend() {
        this.showLegend = null;
    }

    public void deleteShowToolTips() {
        this.showToolTips = null;
    }

    public void deleteShowUrls() {
        this.showUrls = null;
    }

    public Enumeration<SeriesDef> enumerateSeriesDef() {
        return Collections.enumeration(this.seriesDefList);
    }

    public Enumeration<SubTitle> enumerateSubTitle() {
        return Collections.enumeration(this.subTitleList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BarChart) {
            BarChart temp = (BarChart)obj;
            boolean equals = Objects.equals(temp.name, this.name) && Objects.equals(temp.domainAxisLabel, this.domainAxisLabel) && Objects.equals(temp.rangeAxisLabel, this.rangeAxisLabel) && Objects.equals(temp.subLabelClass, this.subLabelClass) && Objects.equals(temp.seriesColorClass, this.seriesColorClass) && Objects.equals(temp.drawBarOutline, this.drawBarOutline) && Objects.equals(temp.showLegend, this.showLegend) && Objects.equals(temp.showToolTips, this.showToolTips) && Objects.equals(temp.showUrls, this.showUrls) && Objects.equals(temp.variation, this.variation) && Objects.equals(temp.plotOrientation, this.plotOrientation) && Objects.equals(temp.title, this.title) && Objects.equals(temp.imageSize, this.imageSize) && Objects.equals(temp.subTitleList, this.subTitleList) && Objects.equals(temp.gridLines, this.gridLines) && Objects.equals(temp.seriesDefList, this.seriesDefList) && Objects.equals(temp.plotBackgroundColor, this.plotBackgroundColor) && Objects.equals(temp.chartBackgroundColor, this.chartBackgroundColor);
            return equals;
        }
        return false;
    }

    public ChartBackgroundColor getChartBackgroundColor() {
        return this.chartBackgroundColor;
    }

    public String getDomainAxisLabel() {
        return this.domainAxisLabel;
    }

    public Boolean getDrawBarOutline() {
        return this.drawBarOutline != null ? this.drawBarOutline : Boolean.valueOf("true");
    }

    public GridLines getGridLines() {
        return this.gridLines;
    }

    public ImageSize getImageSize() {
        return this.imageSize;
    }

    public String getName() {
        return this.name;
    }

    public PlotBackgroundColor getPlotBackgroundColor() {
        return this.plotBackgroundColor;
    }

    public String getPlotOrientation() {
        return this.plotOrientation;
    }

    public String getRangeAxisLabel() {
        return this.rangeAxisLabel;
    }

    public String getSeriesColorClass() {
        return this.seriesColorClass;
    }

    public SeriesDef getSeriesDef(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.seriesDefList.size()) {
            throw new IndexOutOfBoundsException("getSeriesDef: Index value '" + index + "' not in range [0.." + (this.seriesDefList.size() - 1) + "]");
        }
        return this.seriesDefList.get(index);
    }

    public SeriesDef[] getSeriesDef() {
        SeriesDef[] array = new SeriesDef[]{};
        return this.seriesDefList.toArray(array);
    }

    public List<SeriesDef> getSeriesDefCollection() {
        return this.seriesDefList;
    }

    public int getSeriesDefCount() {
        return this.seriesDefList.size();
    }

    public Boolean getShowLegend() {
        return this.showLegend != null ? this.showLegend : Boolean.valueOf("true");
    }

    public Boolean getShowToolTips() {
        return this.showToolTips != null ? this.showToolTips : Boolean.valueOf("false");
    }

    public Boolean getShowUrls() {
        return this.showUrls != null ? this.showUrls : Boolean.valueOf("false");
    }

    public String getSubLabelClass() {
        return this.subLabelClass;
    }

    public SubTitle getSubTitle(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.subTitleList.size()) {
            throw new IndexOutOfBoundsException("getSubTitle: Index value '" + index + "' not in range [0.." + (this.subTitleList.size() - 1) + "]");
        }
        return this.subTitleList.get(index);
    }

    public SubTitle[] getSubTitle() {
        SubTitle[] array = new SubTitle[]{};
        return this.subTitleList.toArray(array);
    }

    public List<SubTitle> getSubTitleCollection() {
        return this.subTitleList;
    }

    public int getSubTitleCount() {
        return this.subTitleList.size();
    }

    public Title getTitle() {
        return this.title;
    }

    public String getVariation() {
        return this.variation;
    }

    public boolean hasDrawBarOutline() {
        return this.drawBarOutline != null;
    }

    public boolean hasShowLegend() {
        return this.showLegend != null;
    }

    public boolean hasShowToolTips() {
        return this.showToolTips != null;
    }

    public boolean hasShowUrls() {
        return this.showUrls != null;
    }

    public int hashCode() {
        int hash = Objects.hash(this.name, this.domainAxisLabel, this.rangeAxisLabel, this.subLabelClass, this.seriesColorClass, this.drawBarOutline, this.showLegend, this.showToolTips, this.showUrls, this.variation, this.plotOrientation, this.title, this.imageSize, this.subTitleList, this.gridLines, this.seriesDefList, this.plotBackgroundColor, this.chartBackgroundColor);
        return hash;
    }

    public Boolean isDrawBarOutline() {
        return this.drawBarOutline != null ? this.drawBarOutline : Boolean.valueOf("true");
    }

    public Boolean isShowLegend() {
        return this.showLegend != null ? this.showLegend : Boolean.valueOf("true");
    }

    public Boolean isShowToolTips() {
        return this.showToolTips != null ? this.showToolTips : Boolean.valueOf("false");
    }

    public Boolean isShowUrls() {
        return this.showUrls != null ? this.showUrls : Boolean.valueOf("false");
    }

    public Iterator<SeriesDef> iterateSeriesDef() {
        return this.seriesDefList.iterator();
    }

    public Iterator<SubTitle> iterateSubTitle() {
        return this.subTitleList.iterator();
    }

    public void removeAllSeriesDef() {
        this.seriesDefList.clear();
    }

    public void removeAllSubTitle() {
        this.subTitleList.clear();
    }

    public boolean removeSeriesDef(SeriesDef vSeriesDef) {
        boolean removed = this.seriesDefList.remove(vSeriesDef);
        return removed;
    }

    public SeriesDef removeSeriesDefAt(int index) {
        SeriesDef obj = this.seriesDefList.remove(index);
        return obj;
    }

    public boolean removeSubTitle(SubTitle vSubTitle) {
        boolean removed = this.subTitleList.remove(vSubTitle);
        return removed;
    }

    public SubTitle removeSubTitleAt(int index) {
        SubTitle obj = this.subTitleList.remove(index);
        return obj;
    }

    public void setChartBackgroundColor(ChartBackgroundColor chartBackgroundColor) {
        this.chartBackgroundColor = chartBackgroundColor;
    }

    public void setDomainAxisLabel(String domainAxisLabel) {
        this.domainAxisLabel = domainAxisLabel;
    }

    public void setDrawBarOutline(Boolean drawBarOutline) {
        this.drawBarOutline = drawBarOutline;
    }

    public void setGridLines(GridLines gridLines) {
        this.gridLines = gridLines;
    }

    public void setImageSize(ImageSize imageSize) {
        this.imageSize = imageSize;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPlotBackgroundColor(PlotBackgroundColor plotBackgroundColor) {
        this.plotBackgroundColor = plotBackgroundColor;
    }

    public void setPlotOrientation(String plotOrientation) {
        this.plotOrientation = plotOrientation;
    }

    public void setRangeAxisLabel(String rangeAxisLabel) {
        this.rangeAxisLabel = rangeAxisLabel;
    }

    public void setSeriesColorClass(String seriesColorClass) {
        this.seriesColorClass = seriesColorClass;
    }

    public void setSeriesDef(int index, SeriesDef vSeriesDef) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.seriesDefList.size()) {
            throw new IndexOutOfBoundsException("setSeriesDef: Index value '" + index + "' not in range [0.." + (this.seriesDefList.size() - 1) + "]");
        }
        this.seriesDefList.set(index, vSeriesDef);
    }

    public void setSeriesDef(SeriesDef[] vSeriesDefArray) {
        this.seriesDefList.clear();
        for (int i = 0; i < vSeriesDefArray.length; ++i) {
            this.seriesDefList.add(vSeriesDefArray[i]);
        }
    }

    public void setSeriesDef(List<SeriesDef> vSeriesDefList) {
        this.seriesDefList.clear();
        this.seriesDefList.addAll(vSeriesDefList);
    }

    public void setSeriesDefCollection(List<SeriesDef> seriesDefList) {
        this.seriesDefList = seriesDefList;
    }

    public void setShowLegend(Boolean showLegend) {
        this.showLegend = showLegend;
    }

    public void setShowToolTips(Boolean showToolTips) {
        this.showToolTips = showToolTips;
    }

    public void setShowUrls(Boolean showUrls) {
        this.showUrls = showUrls;
    }

    public void setSubLabelClass(String subLabelClass) {
        this.subLabelClass = subLabelClass;
    }

    public void setSubTitle(int index, SubTitle vSubTitle) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.subTitleList.size()) {
            throw new IndexOutOfBoundsException("setSubTitle: Index value '" + index + "' not in range [0.." + (this.subTitleList.size() - 1) + "]");
        }
        this.subTitleList.set(index, vSubTitle);
    }

    public void setSubTitle(SubTitle[] vSubTitleArray) {
        this.subTitleList.clear();
        for (int i = 0; i < vSubTitleArray.length; ++i) {
            this.subTitleList.add(vSubTitleArray[i]);
        }
    }

    public void setSubTitle(List<SubTitle> vSubTitleList) {
        this.subTitleList.clear();
        this.subTitleList.addAll(vSubTitleList);
    }

    public void setSubTitleCollection(List<SubTitle> subTitleList) {
        this.subTitleList = subTitleList;
    }

    public void setTitle(Title title) {
        this.title = title;
    }

    public void setVariation(String variation) {
        this.variation = variation;
    }
}

