/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.ackd;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.config.ackd.Readers;

@XmlRootElement(name="ackd-configuration")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class AckdConfiguration
implements Serializable {
    private static final long serialVersionUID = -8269227735655606782L;
    public static final boolean DEFAULT_ALARM_SYNC_FLAG = true;
    public static final String DEFAULT_ACK_EXPRESSION = "~(?i)^ack$";
    public static final String DEFAULT_UNACK_EXPRESSION = "~(?i)^unack$";
    public static final String DEFAULT_ESCALATE_EXPRESSION = "~(?i)^esc$";
    public static final String DEFAULT_CLEAR_EXPRESSION = "~(?i)^(resolve|clear)$";
    public static final String DEFAULT_NOTIFYID_MATCH_EXPRESSION = "~(?i).*Re:.*Notice #([0-9]+).*";
    public static final String DEFAULT_ALARMID_MATCH_EXPRESSION = "~(?i).*alarmid:([0-9]+).*";
    @XmlAttribute(name="alarm-sync")
    private Boolean _alarmSync;
    @XmlAttribute(name="ack-expression")
    private String _ackExpression;
    @XmlAttribute(name="unack-expression")
    private String _unackExpression;
    @XmlAttribute(name="escalate-expression")
    private String _escalateExpression;
    @XmlAttribute(name="clear-expression")
    private String _clearExpression;
    @XmlAttribute(name="notifyid-match-expression")
    private String _notifyidMatchExpression;
    @XmlAttribute(name="alarmid-match-expression")
    private String _alarmidMatchExpression;
    @XmlElement(name="readers")
    private Readers _readers;

    public AckdConfiguration() {
    }

    public AckdConfiguration(boolean alarmSync, String ackExpression, String unackExpression, String clearExpression, String escalateExpression, String notifyidMatchExpression, String alarmidMatchExpression, Readers readers) {
        this.setAlarmSync(alarmSync);
        this.setAckExpression(ackExpression);
        this.setUnackExpression(unackExpression);
        this.setClearExpression(clearExpression);
        this.setEscalateExpression(escalateExpression);
        this.setNotifyidMatchExpression(notifyidMatchExpression);
        this.setAlarmidMatchExpression(alarmidMatchExpression);
        this.setReaders(readers);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AckdConfiguration other = (AckdConfiguration)obj;
        if (this._ackExpression == null ? other._ackExpression != null : !this._ackExpression.equals(other._ackExpression)) {
            return false;
        }
        if (this._alarmSync == null ? other._alarmSync != null : !this._alarmSync.equals(other._alarmSync)) {
            return false;
        }
        if (this._alarmidMatchExpression == null ? other._alarmidMatchExpression != null : !this._alarmidMatchExpression.equals(other._alarmidMatchExpression)) {
            return false;
        }
        if (this._clearExpression == null ? other._clearExpression != null : !this._clearExpression.equals(other._clearExpression)) {
            return false;
        }
        if (this._escalateExpression == null ? other._escalateExpression != null : !this._escalateExpression.equals(other._escalateExpression)) {
            return false;
        }
        if (this._notifyidMatchExpression == null ? other._notifyidMatchExpression != null : !this._notifyidMatchExpression.equals(other._notifyidMatchExpression)) {
            return false;
        }
        if (this._readers == null ? other._readers != null : !this._readers.equals(other._readers)) {
            return false;
        }
        return !(this._unackExpression == null ? other._unackExpression != null : !this._unackExpression.equals(other._unackExpression));
    }

    public String getAckExpression() {
        return this._ackExpression == null ? DEFAULT_ACK_EXPRESSION : this._ackExpression;
    }

    public boolean getAlarmSync() {
        return this._alarmSync == null ? true : this._alarmSync;
    }

    public String getAlarmidMatchExpression() {
        return this._alarmidMatchExpression == null ? DEFAULT_ALARMID_MATCH_EXPRESSION : this._alarmidMatchExpression;
    }

    public String getClearExpression() {
        return this._clearExpression == null ? DEFAULT_CLEAR_EXPRESSION : this._clearExpression;
    }

    public String getEscalateExpression() {
        return this._escalateExpression == null ? DEFAULT_ESCALATE_EXPRESSION : this._escalateExpression;
    }

    public String getNotifyidMatchExpression() {
        return this._notifyidMatchExpression == null ? DEFAULT_NOTIFYID_MATCH_EXPRESSION : this._notifyidMatchExpression;
    }

    public Readers getReaders() {
        return this._readers;
    }

    public String getUnackExpression() {
        return this._unackExpression == null ? DEFAULT_UNACK_EXPRESSION : this._unackExpression;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._ackExpression == null ? 0 : this._ackExpression.hashCode());
        result = 31 * result + (this._alarmSync == null ? 0 : this._alarmSync.hashCode());
        result = 31 * result + (this._alarmidMatchExpression == null ? 0 : this._alarmidMatchExpression.hashCode());
        result = 31 * result + (this._clearExpression == null ? 0 : this._clearExpression.hashCode());
        result = 31 * result + (this._escalateExpression == null ? 0 : this._escalateExpression.hashCode());
        result = 31 * result + (this._notifyidMatchExpression == null ? 0 : this._notifyidMatchExpression.hashCode());
        result = 31 * result + (this._readers == null ? 0 : this._readers.hashCode());
        result = 31 * result + (this._unackExpression == null ? 0 : this._unackExpression.hashCode());
        return result;
    }

    public boolean isAlarmSync() {
        return this._alarmSync;
    }

    public void setAckExpression(String ackExpression) {
        this._ackExpression = ackExpression;
    }

    public void setAlarmSync(boolean alarmSync) {
        this._alarmSync = alarmSync;
    }

    public void setAlarmidMatchExpression(String alarmidMatchExpression) {
        this._alarmidMatchExpression = alarmidMatchExpression;
    }

    public void setClearExpression(String clearExpression) {
        this._clearExpression = clearExpression;
    }

    public void setEscalateExpression(String escalateExpression) {
        this._escalateExpression = escalateExpression;
    }

    public void setNotifyidMatchExpression(String notifyidMatchExpression) {
        this._notifyidMatchExpression = notifyidMatchExpression;
    }

    public void setReaders(Readers readers) {
        this._readers = readers;
    }

    public void setUnackExpression(String unackExpression) {
        this._unackExpression = unackExpression;
    }
}

