/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.users;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.users.Contact;
import org.opennms.netmgt.config.users.Password;

@XmlRootElement(name="user")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="users.xsd")
public class User
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="user-id", required=true)
    private String m_userId;
    @XmlElement(name="full-name")
    private String m_fullName;
    @XmlElement(name="user-comments")
    private String m_userComments;
    @XmlElement(name="password", required=true)
    private Password m_password;
    @XmlElement(name="contact")
    private List<Contact> m_contacts = new ArrayList<Contact>();
    @XmlElement(name="duty-schedule")
    private List<String> m_dutySchedules = new ArrayList<String>();
    @XmlElement(name="role")
    private List<String> m_roles = new ArrayList<String>();
    @XmlElement(name="tui-pin")
    private String m_tuiPin;

    public User() {
    }

    public User(String userId) {
        this.m_userId = userId;
    }

    public User(String userId, String fullName, String userComments) {
        this.m_userId = userId;
        this.m_fullName = fullName;
        this.m_userComments = userComments;
    }

    public String getUserId() {
        return this.m_userId;
    }

    public void setUserId(String userId) {
        this.m_userId = userId;
    }

    public String getFullName() {
        return this.m_fullName;
    }

    public void setFullName(String fullName) {
        this.m_fullName = fullName;
    }

    public String getUserComments() {
        return this.m_userComments;
    }

    public void setUserComments(String userComments) {
        this.m_userComments = userComments;
    }

    public Password getPassword() {
        return this.m_password;
    }

    public void setPassword(Password password) {
        this.m_password = password;
    }

    public void setPassword(String password, Boolean salt) {
        this.m_password = new Password(password, salt);
    }

    public List<Contact> getContacts() {
        return this.m_contacts;
    }

    public void addContact(Contact contact) throws IndexOutOfBoundsException {
        this.m_contacts.add(contact);
    }

    public void setContacts(List<Contact> contacts) {
        this.m_contacts.clear();
        this.m_contacts.addAll(contacts);
    }

    public void clearContacts() {
        this.m_contacts.clear();
    }

    public List<String> getDutySchedules() {
        return this.m_dutySchedules;
    }

    public void setDutySchedules(List<String> dutySchedules) {
        this.m_dutySchedules.clear();
        this.m_dutySchedules.addAll(dutySchedules);
    }

    public void addDutySchedule(String dutySchedule) {
        this.m_dutySchedules.add(dutySchedule);
    }

    public void clearDutySchedules() {
        this.m_dutySchedules.clear();
    }

    public List<String> getRoles() {
        return this.m_roles;
    }

    public void setRoles(List<String> roles) {
        this.m_roles.clear();
        this.m_roles.addAll(roles);
    }

    public void addRole(String role) {
        this.m_roles.add(role);
    }

    public void clearRoles() {
        this.m_roles.clear();
    }

    public String getTuiPin() {
        return this.m_tuiPin;
    }

    public void setTuiPin(String tuiPin) {
        this.m_tuiPin = tuiPin;
    }

    public int hashCode() {
        return Objects.hash(this.m_userId, this.m_fullName, this.m_userComments, this.m_password, this.m_contacts, this.m_dutySchedules, this.m_roles, this.m_tuiPin);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof User) {
            User temp = (User)obj;
            return Objects.equals(temp.m_userId, this.m_userId) && Objects.equals(temp.m_fullName, this.m_fullName) && Objects.equals(temp.m_userComments, this.m_userComments) && Objects.equals(temp.m_password, this.m_password) && Objects.equals(temp.m_contacts, this.m_contacts) && Objects.equals(temp.m_dutySchedules, this.m_dutySchedules) && Objects.equals(temp.m_roles, this.m_roles) && Objects.equals(temp.m_tuiPin, this.m_tuiPin);
        }
        return false;
    }

    public String toString() {
        return "User[userId=" + this.m_userId + ", fullName=" + this.m_fullName + ", userComments=" + this.m_userComments + ", password=" + this.m_password + ", contacts=" + this.m_contacts + ", dutySchedules=" + this.m_dutySchedules + ", roles=" + this.m_roles + ", tuiPin=" + this.m_tuiPin + "]";
    }
}

