/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.threshd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.config.threshd.Expression;
import org.opennms.netmgt.config.threshd.Threshold;

@XmlRootElement(name="group")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Group
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlAttribute(name="name", required=true)
    private String name;
    @XmlAttribute(name="rrdRepository", required=true)
    private String rrdRepository;
    @XmlElement(name="threshold")
    private List<Threshold> thresholdList = new ArrayList<Threshold>();
    @XmlElement(name="expression")
    private List<Expression> expressionList = new ArrayList<Expression>();

    public void addExpression(Expression vExpression) throws IndexOutOfBoundsException {
        this.expressionList.add(vExpression);
    }

    public void addExpression(int index, Expression vExpression) throws IndexOutOfBoundsException {
        this.expressionList.add(index, vExpression);
    }

    public void addThreshold(Threshold vThreshold) throws IndexOutOfBoundsException {
        this.thresholdList.add(vThreshold);
    }

    public void addThreshold(int index, Threshold vThreshold) throws IndexOutOfBoundsException {
        this.thresholdList.add(index, vThreshold);
    }

    public Enumeration<Expression> enumerateExpression() {
        return Collections.enumeration(this.expressionList);
    }

    public Enumeration<Threshold> enumerateThreshold() {
        return Collections.enumeration(this.thresholdList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Group) {
            Group temp = (Group)obj;
            boolean equals = Objects.equals(temp.name, this.name) && Objects.equals(temp.rrdRepository, this.rrdRepository) && Objects.equals(temp.thresholdList, this.thresholdList) && Objects.equals(temp.expressionList, this.expressionList);
            return equals;
        }
        return false;
    }

    public Expression getExpression(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.expressionList.size()) {
            throw new IndexOutOfBoundsException("getExpression: Index value '" + index + "' not in range [0.." + (this.expressionList.size() - 1) + "]");
        }
        return this.expressionList.get(index);
    }

    public Expression[] getExpression() {
        Expression[] array = new Expression[]{};
        return this.expressionList.toArray(array);
    }

    public List<Expression> getExpressionCollection() {
        return this.expressionList;
    }

    public int getExpressionCount() {
        return this.expressionList.size();
    }

    public String getName() {
        return this.name;
    }

    public String getRrdRepository() {
        return this.rrdRepository;
    }

    public Threshold getThreshold(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.thresholdList.size()) {
            throw new IndexOutOfBoundsException("getThreshold: Index value '" + index + "' not in range [0.." + (this.thresholdList.size() - 1) + "]");
        }
        return this.thresholdList.get(index);
    }

    public Threshold[] getThreshold() {
        Threshold[] array = new Threshold[]{};
        return this.thresholdList.toArray(array);
    }

    public List<Threshold> getThresholdCollection() {
        return this.thresholdList;
    }

    public int getThresholdCount() {
        return this.thresholdList.size();
    }

    public int hashCode() {
        int hash = Objects.hash(this.name, this.rrdRepository, this.thresholdList, this.expressionList);
        return hash;
    }

    public Iterator<Expression> iterateExpression() {
        return this.expressionList.iterator();
    }

    public Iterator<Threshold> iterateThreshold() {
        return this.thresholdList.iterator();
    }

    public void removeAllExpression() {
        this.expressionList.clear();
    }

    public void removeAllThreshold() {
        this.thresholdList.clear();
    }

    public boolean removeExpression(Expression vExpression) {
        boolean removed = this.expressionList.remove(vExpression);
        return removed;
    }

    public Expression removeExpressionAt(int index) {
        Expression obj = this.expressionList.remove(index);
        return obj;
    }

    public boolean removeThreshold(Threshold vThreshold) {
        boolean removed = this.thresholdList.remove(vThreshold);
        return removed;
    }

    public Threshold removeThresholdAt(int index) {
        Threshold obj = this.thresholdList.remove(index);
        return obj;
    }

    public void setExpression(int index, Expression vExpression) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.expressionList.size()) {
            throw new IndexOutOfBoundsException("setExpression: Index value '" + index + "' not in range [0.." + (this.expressionList.size() - 1) + "]");
        }
        this.expressionList.set(index, vExpression);
    }

    public void setExpression(Expression[] vExpressionArray) {
        this.expressionList.clear();
        for (int i = 0; i < vExpressionArray.length; ++i) {
            this.expressionList.add(vExpressionArray[i]);
        }
    }

    public void setExpression(List<Expression> vExpressionList) {
        this.expressionList.clear();
        this.expressionList.addAll(vExpressionList);
    }

    public void setExpressionCollection(List<Expression> expressionList) {
        this.expressionList = expressionList;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRrdRepository(String rrdRepository) {
        this.rrdRepository = rrdRepository;
    }

    public void setThreshold(int index, Threshold vThreshold) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.thresholdList.size()) {
            throw new IndexOutOfBoundsException("setThreshold: Index value '" + index + "' not in range [0.." + (this.thresholdList.size() - 1) + "]");
        }
        this.thresholdList.set(index, vThreshold);
    }

    public void setThreshold(Threshold[] vThresholdArray) {
        this.thresholdList.clear();
        for (int i = 0; i < vThresholdArray.length; ++i) {
            this.thresholdList.add(vThresholdArray[i]);
        }
    }

    public void setThreshold(List<Threshold> vThresholdList) {
        this.thresholdList.clear();
        this.thresholdList.addAll(vThresholdList);
    }

    public void setThresholdCollection(List<Threshold> thresholdList) {
        this.thresholdList = thresholdList;
    }
}

