/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.rancid.adapter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.config.rancid.adapter.Package;
import org.opennms.netmgt.config.rancid.adapter.Schedule;

@XmlRootElement(name="policy-manage")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class PolicyManage
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlAttribute(name="name", required=true)
    private String name;
    @XmlAttribute(name="delay")
    private Long delay;
    @XmlAttribute(name="retries")
    private Integer retries;
    @XmlAttribute(name="useCategories")
    private Boolean useCategories;
    @XmlAttribute(name="default-type")
    private String defaultType;
    @XmlElement(name="package", required=true)
    private Package _package;
    @XmlElement(name="schedule")
    private List<Schedule> scheduleList = new ArrayList<Schedule>();

    public void addSchedule(Schedule vSchedule) throws IndexOutOfBoundsException {
        this.scheduleList.add(vSchedule);
    }

    public void addSchedule(int index, Schedule vSchedule) throws IndexOutOfBoundsException {
        this.scheduleList.add(index, vSchedule);
    }

    public void deleteDelay() {
        this.delay = null;
    }

    public void deleteRetries() {
        this.retries = null;
    }

    public void deleteUseCategories() {
        this.useCategories = null;
    }

    public Enumeration<Schedule> enumerateSchedule() {
        return Collections.enumeration(this.scheduleList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PolicyManage) {
            PolicyManage temp = (PolicyManage)obj;
            boolean equals = Objects.equals(temp.name, this.name) && Objects.equals(temp.delay, this.delay) && Objects.equals(temp.retries, this.retries) && Objects.equals(temp.useCategories, this.useCategories) && Objects.equals(temp.defaultType, this.defaultType) && Objects.equals(temp._package, this._package) && Objects.equals(temp.scheduleList, this.scheduleList);
            return equals;
        }
        return false;
    }

    public String getDefaultType() {
        return this.defaultType;
    }

    public Long getDelay() {
        return this.delay;
    }

    public String getName() {
        return this.name;
    }

    public Package getPackage() {
        return this._package;
    }

    public Integer getRetries() {
        return this.retries;
    }

    public Schedule getSchedule(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.scheduleList.size()) {
            throw new IndexOutOfBoundsException("getSchedule: Index value '" + index + "' not in range [0.." + (this.scheduleList.size() - 1) + "]");
        }
        return this.scheduleList.get(index);
    }

    public Schedule[] getSchedule() {
        Schedule[] array = new Schedule[]{};
        return this.scheduleList.toArray(array);
    }

    public List<Schedule> getScheduleCollection() {
        return this.scheduleList;
    }

    public int getScheduleCount() {
        return this.scheduleList.size();
    }

    public Boolean getUseCategories() {
        return this.useCategories;
    }

    public boolean hasDelay() {
        return this.delay != null;
    }

    public boolean hasRetries() {
        return this.retries != null;
    }

    public boolean hasUseCategories() {
        return this.useCategories != null;
    }

    public int hashCode() {
        int hash = Objects.hash(this.name, this.delay, this.retries, this.useCategories, this.defaultType, this._package, this.scheduleList);
        return hash;
    }

    public Boolean isUseCategories() {
        return this.useCategories;
    }

    public Iterator<Schedule> iterateSchedule() {
        return this.scheduleList.iterator();
    }

    public void removeAllSchedule() {
        this.scheduleList.clear();
    }

    public boolean removeSchedule(Schedule vSchedule) {
        boolean removed = this.scheduleList.remove(vSchedule);
        return removed;
    }

    public Schedule removeScheduleAt(int index) {
        Schedule obj = this.scheduleList.remove(index);
        return obj;
    }

    public void setDefaultType(String defaultType) {
        this.defaultType = defaultType;
    }

    public void setDelay(Long delay) {
        this.delay = delay;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPackage(Package _package) {
        this._package = _package;
    }

    public void setRetries(Integer retries) {
        this.retries = retries;
    }

    public void setSchedule(int index, Schedule vSchedule) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.scheduleList.size()) {
            throw new IndexOutOfBoundsException("setSchedule: Index value '" + index + "' not in range [0.." + (this.scheduleList.size() - 1) + "]");
        }
        this.scheduleList.set(index, vSchedule);
    }

    public void setSchedule(Schedule[] vScheduleArray) {
        this.scheduleList.clear();
        for (int i = 0; i < vScheduleArray.length; ++i) {
            this.scheduleList.add(vScheduleArray[i]);
        }
    }

    public void setSchedule(List<Schedule> vScheduleList) {
        this.scheduleList.clear();
        this.scheduleList.addAll(vScheduleList);
    }

    public void setScheduleCollection(List<Schedule> scheduleList) {
        this.scheduleList = scheduleList;
    }

    public void setUseCategories(Boolean useCategories) {
        this.useCategories = useCategories;
    }
}

